/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef PlanesOperations_H_
#define PlanesOperations_H_

#include <math.h>

#include <iostream>
#include <vector>

using namespace std;

class PlanesOperations  {

public:
	PlanesOperations();	
	~PlanesOperations();	
	
	

    double* getCrossProduct(double* vect0,double* vect1);
    double getDotProduct(double* vect0,double* vect1);
    double* getNormal(double* vect);
    double getMagnitud(double* vect);
    double* makeVector(double *podouble0, double* podouble1);

    void getCrossProduct(double* vect0,double* vect1, double* vectres);
    void getNormal(double* vect, double* vectnorm);
    void makeVector(double* podouble0, double* podouble1, double* vectres);
    /**
    *    Adds to vectors, the result is in vectres;
    *@param double* vect0, the first vector
    *@param double* vect1, the second vector
    *@param double* vectres, the resulting vector
    */
    void addVectors(double* vect0, double* vect1, double*vectres);
    /**
    *    multiply a vector with a given scalar
    *@param double* vect0, the vector
    *@param double scalar, the scalar value
    *@param double* vectres, the resulting vector
    */
    void scalarVector(double* vect0, double scalar, double*vectres);
    
    vector<double> getCrossProduct(vector<double> vect0,vector<double> vect1);
    double  getDotProduct(vector<double> vect0,vector<double> vect1);
    vector<double> getNormal(vector<double> vect);
    double  getMagnitud(vector<double> vect);
    vector<double> makeVector(vector<double> podouble0, vector<double> podouble1);
    /**
    *    Adds to vectors, the result is in vectres;
    *@param double* vect0, the first vector
    *@param double* vect1, the second vector
    *@param double* vectres, the resulting vector
    */
    vector<double> addVectors(vector<double> vect0, vector<double> vect1);
    /**
    *    multiply a vector with a given scalar
    *@param double* vect0, the vector
    *@param double scalar, the scalar value
    *@param double* vectres, the resulting vector
    */
    vector<double> scalarVector(vector<double> vect0, double scalar);
	
};

#endif /*PlanesOperations_H_*/
