
#ifndef __WidgetShowNPoints_h_INCLUDED__
#define __WidgetShowNPoints_h_INCLUDED__

#include "ModelShowNPoints.h"
#include "ViewShowNPoints.h"

#include <wx/panel.h>
#include <wx/textctrl.h>
#include <wx/slider.h>
#include <wx/stattext.h>
#include <wx/checkbox.h>
#include <wx/spinctrl.h>

#include "vtkPolyData.h"



class WidgetShowNPoints : public wxPanel
{
  public:
	  WidgetShowNPoints( wxWindow *parent , int type );
	  ~WidgetShowNPoints();
      void SetCurrentPoint(int idCurrentPoint );
      void OnBackPoint(wxCommandEvent &event);
      void OnNextPoint(wxCommandEvent &event);
      void StopAutoAddPoints();
      void AutoAddPoints();
      void OnAutoAddPoints_tool();
      void OnAutoAddPoints_();
      void OnAutoAddPoints(wxCommandEvent& event);
      void OnAddPoint_();
      void OnAddPoint__();
      void OnAddPoint(wxCommandEvent &event);
	  void OnInsertPoint(wxCommandEvent& event);//CFT
      void OnSetPoint_();
	  void OnSetPoint(wxCommandEvent& event);
      void OnTrackPoint(wxCommandEvent& event);
      void OnTrackPoint_();
      void OnTrackPoint_tool();
      void TrackingPoint();
      void StopTrackPoint();
      void DetectCollectionActive();

	  void OnRenamePoint(wxCommandEvent& event);
      void OnErasePoint_();
	  void OnErasePoint(wxCommandEvent& event);
	  void OnEraseLastPoint(wxCommandEvent &event); 
      void DeleteAllPoints_();
      void OnDeleteAllPoints_();
	  void OnDeleteAllPoints(wxCommandEvent &event);

	  void OnSavePoints(wxCommandEvent &event);   
	  void OnLoadPoints(wxCommandEvent &event);

	  virtual void UpdatePoints(wxCommandEvent &event);
      void UpdatePoints_();

      void OnVisuActualCollection(wxCommandEvent &event);
      void InsertCollection();
      void InsertCollectionBefore_();
      void OnInsertCollectionBefore_();
      void OnInsertCollectionBefore(wxCommandEvent &event);
      void InsertCollectionAfter_();
      void OnInsertCollectionAfter_();
      void OnInsertCollectionAfter(wxCommandEvent &event);
      void CreatePointsIntoNewCollection();
      void OnDeleteCollection_();
      void OnDeleteCollection(wxCommandEvent &event);
      void DeleteCollection_();
      void OnBackCollection(wxCommandEvent &event);
      void OnNextCollection(wxCommandEvent &event);
      void OnSaveCollections(wxCommandEvent &event);
      void OnSaveCollections_( std::string filename );
      void OnSaveCollectionsIdsCurrent_( std::string filename );
      void OnLoadCollections(wxCommandEvent &event);
      void OnLoadCollections_( std::string filename );
      void OnLoadCollectionsIdsCurrent_( std::string filename );
      void ResetCollections_();
      void OnResetCollections_();
      void OnResetCollections(wxCommandEvent &event);
      void GetCollectionPoint(int idCol,int idPoint, double *pPoint);
      void SetCollectionPoint(int idCol, int idPoint, std::vector<double> modPoint);
      void SetActualCollection( int actual );
      void OnUndo(wxCommandEvent &event);
      void OnRedo(wxCommandEvent &event);
      void UndoRedo_SaveCollection();
      std::string GetUndoRedoFileName();

      void MovePoint_(double step);
      void OnMovePointUp(wxCommandEvent& event);
      void OnMovePointDown(wxCommandEvent& event);

      void RefreshCollectionText();
      void RefreshColourCollection();
      void InvertLstPoints_();
      void OnInvertLstPoints_();

      // EED 2022-05-19
	  //void RefreshPoint(int id);
      //void RefreshPoints();
      //void AddVtkPoint();

	  void SetColour(std::vector<double> colour);
	  void SetOpacity(double opacity);
	  void SetRadio(double radio);
	  void SetImage(vtkImageData *image);
	  void SetRenderer(vtkRenderer *renderer);
	  void SetReferencePoint(std::vector<double> point);

	  void AddPoint(double x, double y, double z, std::string label);
      void OnInsertPoint_();
	  void InsertPoint(double x, double y, double z, std::string label);//CFT

      int GetLstModelShowNPointsSize();
	  ModelShowNPoints* GetModelShowNPoints();
	  ModelShowNPoints* GetModelShowNPoints(int id);
      ViewShowNPoints* GetViewShowNPoints();
	  void SetInitLstPoints( std::vector<double> initLstPointsX,  std::vector<double> initLstPointsY, std::vector<double> initLstPointsZ, std::vector<std::string> initLstLabels,  std::vector<int> initLstIndexs );

    void                        SetType(int type);
    int                         GetType();
    double                      GetRadio();
    double                      GetOpacity();
    virtual void                SetOutputBox();
    bool                        ErasePoint(int id);

    void                        SetAuxMesh(vtkPolyData* , std::vector<double> spc, std::vector<double> params);
    
    std::vector<double>         GetLstPointsX();
    std::vector<double>         GetLstPointsY();
    std::vector<double>         GetLstPointsZ();
    std::vector<std::string>    GetLstLabels();
    std::vector<int>            GetLstIndexs();
    std::vector<int>            GetLstSelectedIndexs();


  protected:
  private:
        std::vector<ViewShowNPoints*>   lstViewShowNPoints;
        //NTU: For updating points
        wxStaticText          		    *askPointLabel;
        wxTextCtrl            		    *textCtrl;
        wxStaticText                    *txtNrCollections;
        wxStaticText          		    *txtNrPoints;
    
//        wxSlider              		*sdrOpacity;
//        wxSlider              		*sdrRadio;
        wxSpinCtrl                      *sCtrlRadio;
        wxSpinCtrl                      *sCtrlOpacity;

        wxCheckBox                      *cbTrackPoint;
        wxCheckBox                      *cbAutoAddPoints;
        wxCheckBox                      *cbVisuActualCollection;

        std::vector<ModelShowNPoints*>  lstModelShowNPoints;
        int							    mtype;
        int                             mActualCollection;
//        int                             idTrack;
        int                             idUndoRedo;
        int                             maxUndoRedo;
        std::string                     UndoRedoDir;
    
        vtkPolyData                     *aux_mesh;
        std::vector<double>             aux_mesh_spc;
        int                             aux_mesh_type;
    
};






#endif // __WidgetShowNPoints_h_INCLUDED__

