/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _BASE_FILTER_MANUAL_PAINT_H_
#define _BASE_FILTER_MANUAL_PAINT_H_

#include <vtkVersionMacros.h>
#include <vtkImageData.h>

//#include "regionStructUR.h"

#include "imageModificationManager.h"


class baseFilterManualPaint {

public:
	baseFilterManualPaint();
	virtual ~baseFilterManualPaint();
	virtual void SetImages(vtkImageData *image,vtkImageData *image2);
	void SetPoint(int px, int py, int pz);
	void Set2D3D(int dim2D3D);
	void SetGrayLevel(double graylevel);
	void SetDirection(int direction);
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	void ResetGeneralMinMax();
//	void SetGeneralMinMax(int minX, int maxX, int minY, int maxY, int minZ, int maxZ);
	void GetScalarRange(double * range);
    void SetRangeMin( int min );//DFCH
    void SetRangeMax( int max );//DFCH
    int GetRangeMin( ); //DFCH
    int GetRangeMax( ); //DFCH
	ImageMManager* GetImageMManager(); //DFCH
	void CleanImageMManager(); //DFCH
	virtual void Run(int px, int py, int pz);
private:
protected:
	ImageMManager 	*_IMManager; //Saves the last modified region (MinX, MaxX, MinY, MaxY, MinZ, MaxZ).
	vtkImageData 	*_image;
	vtkImageData 	*_image2;
	int 			_direction;
	int 			_minX; // min max of the image
	int 			_minY;
	int 			_minZ;

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	int 			_px; // start point of the brush
//	int 			_py;
//	int 			_pz;
//	int 			_maxX;
//	int 			_maxY;
//	int 			_maxZ;
//	int 			_pMinX; // General min max of many brush actions
//	int 			_pMinY;
//	int 			_pMinZ;
//	int 			_pMaxX;
//	int 			_pMaxY;
//	int 			_pMaxZ;

	int 			_dimX;
	int 			_dimY;
	int 			_dimZ;
	bool 			_2D3D;
	double 			_graylevel;
    int    			_RangeMin;
    int    			_RangeMax;

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
	long int		_OneColumn;
	long int		_OneLine;
	long int		_OnePlane;


};

#endif // _BASE_FILTER_MANUAL_PAINT_H_
