/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonGroupFactory.h
 * @brief Contains ButtonGroupFactory class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTONGROUPFACTORY_H
#define BUTTONGROUPFACTORY_H

#include <wx/window.h>

#include "system.h"
#include "button.h"
#include "buttonGroup.h"
#include "containerSettings.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::model>
	 *	@brief Contains the implementation of the model in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace model
	{
		/*! @class ButtonGroupFactory buttonGroupFactory.h "buttonGroupFactory.h"
		 *	@brief This class contains the ButtonGroup factory.
		 *  @details This class creates a container of group of buttons.
		 *  @see <a href="http://en.wikipedia.org/wiki/Factory_method_pattern">Factory Pattern</a>
		 */
		class ButtonGroupFactory
		{
			public:
				//typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::Button Button;
				 *	@brief Defines the Button type.
				 */
				typedef creaButtonContainer::view::Button Button;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				 *	@brief Defines the ButtonGroup type.
				 */
				typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::ContainerSettings ButtonGroupModel;
				 *	@brief Defines the ButtonGroupModel type.
				 */
				typedef creaButtonContainer::model::ContainerSettings ButtonGroupModel;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::list< ButtonGroup* > ButtonGroupContainer;
				 *	@brief Defines the ButtonGroupContainer type.
				 */
				typedef std::list<ButtonGroup*> ButtonGroupContainer;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::map< long, Button* > ButtonContainer;
				 *	@brief Defines the ButtonContainer type.
				 */
				typedef std::map<long, Button*> ButtonContainer;
				// ----------------------------------------------------------------------------------
				//end of typedef definition
			public:
				/*!	@fn ButtonGroupFactory::ButtonGroupFactory( );
				 *	@brief This is the default constructor.
				 */
				ButtonGroupFactory();
				// -------------------------------------------------------------------------------
				/*!	@fn virtual ButtonGroupFactory::~ButtonGroupFactory( );
				 *	@brief This is the destructor.
				 */
				virtual
				~ButtonGroupFactory();

				/*! @fn ButtonGroupContainer ButtonGroupFactory::CreateButtonGroupContainer( wxWindow* parent, ButtonGroupModel* settings );
				 * @brief This method creates the ButtonGroupContainer.
				 * @param parent the wxWindow* parent to be attached.
				 * @param settings The Container settings.
				 * @exception std::bad_alloc
				 * @return ButtonGroupContainer The wx button group container.
				 */
				ButtonGroupContainer
				CreateButtonGroupContainer(wxWindow* parent,
						ButtonGroupModel* settings);
			private:

				/*! @fn ButtonContainer ButtonGroupFactory::GetButtons( wxWindow* parent, ButtonList buttonModel );
				 * @brief  This method creates a wx button container for a group.
				 * @param parent the wxWindow* parent to be attached.
				 * @param buttonModel The button list with its own information.
				 * @exception std::bad_alloc
				 * @return ButtonContainer The wx button container.
				 */
				ButtonContainer
				GetButtons(wxWindow* parent, ButtonList buttonModel);
		};
	}				//ecapseman
}				//ecapseman

#endif // CARTOBUTTONFACTORY_H
