/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file listConfigDialog.h
 * @brief This contains the ListConfigDialog class.
 * @author Monica ESPINOSA (espinosa[AT]creatis.insa-lyon.fr)
 * @date  2015-01-02
 */

#ifndef LISTCONFIGDIALOG_H
#define LISTCONFIGDIALOG_H

#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/gbsizer.h>
#include <wx/wx.h>
#include <wx/bmpbuttn.h>
#include <wx/msgdlg.h>


#include <string>
#include <vector>

#include "functor.h"
#include "listWx.h"
#include "ArrowBackG.xpm"
#include "ArrowNextG.xpm"
#include "ArrowTopG.xpm"
#include "ArrowDownG.xpm"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class ListConfigDialog listConfigDialog.h "listConfigDialog.h"
		 *	@brief This class contains the list in the wxDialog.
		 *  @details This class contains the information of a Dialog with the lists, it derives from wxDialog.
		 *  @see <a href="http://docs.wxwidgets.org/trunk/classwx_dialog.html">wxDialog</a>
		 */
		class ListConfigDialog: public wxDialog
		{
			public:
				//typedef definition.
				// ----------------------------------------------------------------------------------
				/*!	typedef creaButtonContainer::model::TFunctor TFunctor;
				 *	@brief Defines the TFunctor type.
				 */
				typedef creaButtonContainer::model::TFunctor TFunctor;
				/*!	typedef creaButtonContainer::view::ListWx ListWx;
				 *	@brief Defines the List Panel.
				 */
				typedef creaButtonContainer::view::ListWx ListWx;
				// ----------------------------------------------------------------------------------
				//end of typedef definition.
			public:
				// ----------------------------------------------------------------------------------
				/*! @fn ListConfigDialog( wxWindow* parent, wxWindowID id,const wxString& title,
				 ListWx* modelList, ListWx* currentList );
				 *	@brief This is the parameterized constructor.
				 * 	@param parent The wxWindow pointer to parent.
				 * 	@param id The wxID of the button.
				 * 	@param title //The title wxDialog.
				 * 	@param modelList //The list is filled with the elements of model.
				 * 	@param currentList //The list is filled with the events.
				 */
				ListConfigDialog(wxWindow* parent, wxWindowID id, const wxString& title,
						ListWx* modelList, ListWx* currentList);
				// ----------------------------------------------------------------------------------
				/*! @fn virtual ~Button( );
				 *	@brief This is the destructor.
				 */
				virtual
				~ListConfigDialog();
				// ----------------------------------------------------------------------------------
				/*! @fn void OnAdd( wxCommandEvent& event );
				 *  @brief This method add an item to current list.
				 * 	@param event
				 */
				void
				OnAdd(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void OnDelete( wxCommandEvent& event );
				 *  @brief This method remove an item of current list.
				 * 	@param event
				 */
				void
				OnDelete(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void OnMoveUp( wxCommandEvent& event );
				 *  @brief This method move up an item of current list.
				 * 	@param event
				 */
				void
				OnMoveUp(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void OnMoveDown( wxCommandEvent& event );
				 *  @brief This method move down an item of current list.
				 * 	@param event
				 */
				void
				OnMoveDown(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void OnOk( wxCommandEvent& event );
				 *  @brief This method confirm the changes of current list.
				 * 	@param event
				 */
				void
				OnOk(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void OnCancel( wxCommandEvent& event );
				 *  @brief This method discard the changes of current list.
				 * 	@param event
				 */
				void
				OnCancel(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------

			private:

				wxBitmapButton* m_AddButton;				//!< ">" Add button.
				wxBitmapButton* m_RemoveButton;				//!< "<" Remove button.
				wxButton* m_OkButton;				//!< "Ok" Remove button.
				wxButton* m_CancelButton;				//!< "Cancel" Remove button.
				wxBitmapButton* m_UpButton;				//!< "/\" Move Up button.
				wxBitmapButton* m_DownButton;				//!< "\/" Move Down button.
				wxArrayString m_LastStatus; //!<Last status array.

				ListWx* m_OriginalListWx; //!< The Original list.
				ListWx* m_CurrentListWx; //!<The Configurable list.
		};
	}
}

#endif // LISTCONFIGDIALOGL_H
