/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __mBAR__RANGE__
#define __mBAR__RANGE__

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "wx/colordlg.h"

// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "marTypes.h"

//----------------------------------------------------------------------------
//DECLARING THE NEW EVENT
//wxEVT_TSBAR= event of the two side bar
//----------------------------------------------------------------------------

//EED 2022-09-30
wxDECLARE_EVENT(wxEVT_TSBAR, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_TSBAR_ACTUAL, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_TSBAR_START, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_TSBAR_END, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_TSBAR_MOVED, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_SELECTION_END, wxCommandEvent);

/* EED 2022-09-30
BEGIN_DECLARE_EVENT_TYPES()
 	DECLARE_EVENT_TYPE(wxEVT_TSBAR,-1) 
	DECLARE_EVENT_TYPE(wxEVT_TSBAR_ACTUAL,-1)
//	DECLARE_EXPORTED_EVENT_TYPE(MARACASVISULIB_EXPORTS,wxEVT_TSBAR_ACTUAL,-1)
//	extern creaMaracasVisu_EXPORT const wxEventType wxEVT_TSBAR_ACTUAL;
 	DECLARE_EVENT_TYPE(wxEVT_TSBAR_START,-1)
 	DECLARE_EVENT_TYPE(wxEVT_TSBAR_END,-1)
 	DECLARE_EVENT_TYPE(wxEVT_TSBAR_MOVED,-1)
	DECLARE_EVENT_TYPE(wxEVT_SELECTION_END,-1)
END_DECLARE_EVENT_TYPES()
*/



//-------------------------------------------------------------------------------------------------------------
// Enum declarations
//-------------------------------------------------------------------------------------------------------------
/** Command IDs used by pColorPoint */
enum
{
	cntID_CHANGE_COLOR = 7000,
	cntID_ENABLE_ACTUAL,	
	cntID_MOVABLE_ACTUAL_BAR,
};


class creaMaracasVisu_EXPORT mBarRange :public  wxPanel{
//EED-2019-10-25 class creaMaracasVisu_EXPORT mBarRange :public  wxScrolledWindow{
public:
	//------------------------------------
	//Constructors & Destructors
	//------------------------------------
	mBarRange(wxWindow *parent, int w, int h);
	~mBarRange();
	//------------------------------------
	// Bar Methods
	//------------------------------------
	void Refresh(bool eraseBackground = true, const wxRect* rect = NULL);
	void OnPaint( wxPaintEvent &WXUNUSED(event) );
	void OnSize( wxSizeEvent &WXUNUSED(event) );
	void RefreshHorizontalView();
	void RefreshVerticalView();
	void RefreshForce();
	void OnMouseMove(wxMouseEvent& event );
	void onKey(wxKeyEvent& event);

	void DrawBar();
	//------------------------------------
	// Getters & Setters
	//------------------------------------
	//Actual triangle
	int GetPixelActual();
	void SetPixelActual(int i);

	//Start of the bar
	int GetPixelStart();
	void SetPixelStart(int i);

	//End of the bar
	int GetPixelEnd();
	void SetPixelEnd(int i);

	//Logical Max
	double GetMax();
	void SetMax(double i);

	//Logical Min
	double GetMin();
	void SetMin(double i);

	//Rectangule Height
	int GetHeight();
	void SetHeight(int h);

	//Width
	int GetWidth();
	void SetWidth(int w);

	int filtreValue(int value);
	
	//Logical Start
	int GetStart();
	void SetStart(int newstart);

	//Logical End
	int GetEnd();
	void SetEnd(int newend);

	//logical actual
	int GetActual();
	void SetActual(int newactual);


	//The triangles half width managment
	int GetTrianglesHalfWidth();
	void SetTrianglesHalfWidth(int nwTriHalfWidth);
	

	//Orientation (false for vertical, true is default for horizontal)
	bool GetOrientation();
	void SetOrientation(bool orientation);

	//Manage the property of the actual triangle to be between de start and the end
	bool GetInRangeProperty();
	void SetInRangeProperty(bool in);

	//Inform if the actual triangle is between the start and the end triangles
	bool IsActualInRange();

	/*
	* Sets the property for viewing or not the bar labels information
	*/
	void setVisibleLabels (bool setVisible);

	/*
	* Sets the property for viewing or not the bar labels information
	* return _visibleLables The state of visible labels or not 
	*/
	bool getIfVisibleLabels ();

	/*
	* Sets the represented minimum and maximunm values
	* param minRealValue The minimum represented value (real value)
	* param maxRealValue The maximum represented value (real value)
	*/
	void setRepresentedValues(double minRealValue,double maxRealValue);

	/**
	* Sets the device start drawing left-superior (pixel) start point 
	* param deviceStart_x Pixel start for x-coord
	* param deviceStart_y Pixel start for y-coord
	*/
	void setDeviceBlitStart ( wxCoord deviceStart_x, wxCoord deviceStart_y );


	/*
	* Set active state 
	* param activeNow The new state
	*/
	void setActiveStateTo (bool activeNow);
	
	/*
	* Gets the active state of the bar
	*  return isActive The actual state
	*/
	bool isActive();

	/*
	* Gets the real-x value to draw a vertical line
	* return realX_vertical_line The real x value for the vertical line
	*/
	int	getRealX_vertical_line();

	/*
	* Sets the real-x value to draw a vertical line
	* param realX_vertical_line The new real x value for the vertical line
	*/
	void setRealX_vertical_line(int newReal_x);

	//*******************************************************************************************************
	// Event methods
	//*******************************************************************************************************

	/**
	* Shows the popup menu 
	*/
	void onShowPopupMenu (wxMouseEvent& event);
	/**
	* Reacts to the cntID_CHANGE_COLOR wxCommandEvent and adds a color degrade point to the color bar.
	* param & anEvent The wxCommandEvent actioned event 
	*/
	void onChangePartColor ( wxCommandEvent& anEvent );


	/**
	* Reacts to the cntID_ENABLE_ACTUAL wxCommandEvent enables the actual to be between the the range.
	* param & anEvent The wxCommandEvent actioned event 
	*/
	void onEnableRange_Actual ( wxCommandEvent& anEvent );

	/**
	* Reacts to the cntID_MOVABLE_ACTUAL_BAR wxCommandEvent by enabling or disabling the property of moving the actual triangle with the bar, just when it is inside of it.
	* param & anEvent The wxCommandEvent actioned event 
	*/
	void onMovable_ActualWithBar ( wxCommandEvent& anEvent );

	/*
	* Gets the device value form the end of this panel to the end of the drawing area in the device in pixels
	* return deviceEndMargin The value asigned to the right margin
	*/
	int	getDeviceEndX();
	

	/*
	* Sets the new device (deviceEndMargin) value form the end of this panel to the end of the drawing area in the device
	* param newDeviceEnd_pixels The new pixel value to asign to the right(horizontal view), underneath(vertical view) margin in pixels
	*/
	void setDeviceEndMargin(int newDeviceEnd_pixels);

	/*
	* Gets the last clickedX pixel coord inside the bar with respect to the container panel.
	* return clickedX The x-coord pixel value
	*/
	int getClickedX();

	/*
	* Sets the last clickedX pixel coord inside the bar with respect to the container panel.
	* param nwClickX The x-coord pixel value
	*/
	void setClickedX(int nwClickX);

	/*
	* Gets the start porcentage with respect to the represented values of the bar
	* return The porcentage represented by the start  showing point
	*/
	float getStartShowPorcentage();

	/*
	* Gets the end porcentage with respect to the represented values of the bar
	* return The porcentage represented by the end showing point
	*/
	float getEndShowPorcentage();

	/*
	* Gets the actual porcentage with respect to the represented values of the bar
	* return The porcentage represented by the actual  showing point
	*/
	float getActualShowPorcentage();

	/*
	* Gets the logic value of a pixel point that comes in the coords of the container panel.
    * param thePixel Is the pixel to convert
	* return Is the correspondig value to the given pixel-value in logic bar coords
	*/
	int getLogicValueofPixel(int thePixel);


	/*
	* Sets the condition for knowing if the actual triangle is being drawed or not
	* param drawActual The condition to set for drawing or not the actual control (true for drawing)
	*/
	void setIfWithActualDrawed(bool drawActual);

	/*
	* Gets the condition for knowing if the actual triangle is being drawed or not
	* return withActualDrawed The condition for drawing or not the actual control
	*/
	bool getIfWithActualDrawed();

	/*
	* Method that creates and send the given id-event to the event handler
	* param theEventType Is the event id type identification for generating the event
	*/
	void createAndSendEvent(WXTYPE theEventType);

	/*
	* Sets the background color od the bar
	* theColor The color to set to the backgroundColor
	*/
	void setBackgroundColor(wxColour theColor);

	/*
	* Sets the guide line color
	* param theNwGuideLineColor The color to set to the guideLineColor
	*/
	void setGuideLineColour(wxColour theNwGuideLineColor);


	/*
	* Gets the guide line color
	* return guideLineColor The color of the guideLine
	*/
	wxColour getGuideLineColour();

	void onLeftClicDown(wxMouseEvent& event );

	void onLeftClickUp(wxMouseEvent& event );


private:
	//Rectangle width
	int                        _w;
	//Rectangle Height
	int                        _h;
	//Actual value
	int                        _actual;
	//Start of the rectangule
	int                        _start;
	//End of the rectangule
	int                        _end;
	//Logical Max
	double                    _max;
	//Logical Min
	double                     _min;
	//Initial point when moving the rectangule bar according to bar reference 
	int						   _initialPoint;
	/*
	* Represents the id of the selected moving part of the bar where:
	* 1 is for Start triangle, 2 for end triangle, 3 for actual triangle and 4 for the bar
	*/
	int						   _selectionMoveId;

	//orientation of the rectangle is true when is horizontal and is the default value
	bool						_orientation;

	/*
	* The property for identifying if the actual triangle needs to be or not between the limit triangles
	*/
	bool						_in_rangeProperty;

	/*
	* The property for setting the acutal triangle to move with the bar keeping proportions with the limits
	*/
	bool						_moveActualWithBar;

	/*
	* The property for setting visible or not the bar labels information
	*/
	bool					   _visibleLables;
	/*
	* X-Coord for left-superior device visible drawing
	*/
	wxCoord						deviceStart_x;	

	/*
	* Y-Coord for left-superior device visible drawing
	*/
	wxCoord						deviceStart_y;

	/*
	* X-Coord for right device margin
	*/
	wxCoord						deviceEndMargin;	

	/*
	* Represents the active state of the bar
	*/
	bool activeState;

	/*
	* Represents the option of activating or not the drawing of the actual triangle, that in default value is true for drawing it
	* The dafault value is true (use the actual triangle)
	*/
	bool withActualDrawed;

	/*
	* The colour of the start triangle
	*/          
	wxColour start_Colour;

	/*
	* The colour of the actual triangle
	*/          
	wxColour actual_Colour;

	/*
	* The colour of the end triangle
	*/          
	wxColour end_Colour;

	/*
	* The colour of the bar
	*/          
	wxColour bar_Colour;
	/*
	* Represents the real-x value to draw a vertical line
	*/
	int			realX_vertical_line;

	/*
	* Represents the last clickedX coord inside the bar.
	*/
	int			clickedX;

	/*
	* Represents the orientation for the numbers view label in the information bitmap.
	* Where  -4:left, -6:right, -8:up, -2: down respect to the bar
	*/
	int			numberOrientation;	
	/*
	* Represents the logic initial reference start point used for dragging
	*/
	int			logicInitial_start;
	/*
	* Represents the logic intial reference end point used for dragging
	*/
	int			logicInitial_end;
	/*
	* Represents the logic initial reference actual point used for dragging
	*/
	int			logicInitial_actual;

	/*
	* Represents the pixel value assigned to as half of the width of the triangles 
	*/
	int			trianglesHalfWidth;

	/*
	* Represents the background color of the panel (this) where the bar is. The default color is the imediately parent background color
	*/
	wxColour	backgroundColor;
	/*
	* Represents the color of the dot-line use as guides. The default color is RED. 
	*/
	wxColour	guideLineColor;


	bool acceptedClick;
	

	/*
	* The color bar pop menu
	*/
	wxMenu b_popmenu; 
	//the bar bitmap device
	wxBitmap        *_bitmap_bar;
	//the info bitmap device 
	wxBitmap        *_bitmap_info;


	DECLARE_CLASS(BarRange)

	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE()
};



#endif



