/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContour3DControler_h
#define manualContour3DControler_h

#include "wxMPRBaseData.h"
#include "manualContourControler.h"
#include "manualView3DContour.h"

/// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT manualContour3DControler:  public manualContourControler
{
public:
	manualContour3DControler();
	virtual ~manualContour3DControler();
	virtual manualContour3DControler * Clone();
	void CopyAttributesTo( manualContour3DControler *cloneObject );

	virtual bool OnLeftButtonDown(); 
	virtual bool OnChar(); 
	virtual void InsertPoint(int x, int y, int z);
	virtual void MouseClickLeft(int x, int y);
			void ResetOrientationPlane();

	vtkMPRBaseData	*GetVtkMPRBaseData();
			void	SetVtkMPRBaseData (vtkMPRBaseData *vtkmprbasedata );


protected:
private:
	vtkMPRBaseData *_vtkmprbasedata; 

};


#endif // manualContour3DControler_h
