/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __pColorPoint_h__
#define __pColorPoint_h__

//------------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
//------------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class pColorPoint : public wxObject {

public:
	//------------------------------------------------------------------------------------------------------------
	// Constructors and destructors
	//------------------------------------------------------------------------------------------------------------

	/**
	* Create a point of the function.
	* @param x The x real value
	* @param _color The asigned colour 
	* @param isTemp The temporal o fixed asignation to the color
	*/
	pColorPoint(double  x , wxColour  col, bool isTemp);

	~pColorPoint();

	//------------------------------------------------------------------------------------------------------------
	// Methods definition
	//------------------------------------------------------------------------------------------------------------

	/*
	* Returns the x-value of the point
	* @retval realX
	*/
	double getRealX ();
	/**
	* Returns the colour of the point
	* @retval colour
	*/
	wxColor getColor ();
	/**
	* Sets the x-value of the point
	* @param x
	*/
	void setRealX(double x)
	{
		realX = x;
	}
	/**
	* Sets the  colour of the point
	* @param _col
	*/	
	void setColor(wxColour _col)
	{
		colour = _col;
	}

	/**
	* Indicates if the colour point is temporal or not
	* @retval isTemporal
	*/
	bool isTemporalColor ();
	
	//------------------------------------------------------------------------------------------------------------
	// Attributes declration
	//------------------------------------------------------------------------------------------------------------

private:
	/*
	* The x-value of the point
	*/
	double realX;
	/*
	* The colour of the point
	*/          
	wxColour colour;
	/*
	* Represents the attibute of being temporal or not
	*/
	bool isTemporal;
	
	DECLARE_CLASS (pColorPoint)
};

#endif


