/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#ifndef __pGraphicalFunction_h__
#define __pGraphicalFunction_h__

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------


#include "pPlotterLayer.h"
#include "pFunctionPoint.h"
#include "pLogicalFunction.h"
#include "pColorPoint.h"
#include "vtkKochanekSpline.h"
#include <vector>
#include <iostream>
#include <fstream>

/**
 this scale, scales each function with its maximum x, and maximum y
 in its points
*/
#define DEFECT_SCALE 1
/**
 this scale with the maximun x  and y of all the functions defined
*/
#define MAX_SCALE 2
/**
 this scales with the scale giving by the user of the widget
*/
#define USER_SCALE 3

/*
 Types of Plotter
*/
/*
 Lets to the user to plot any number of the
 functions
*/
#define DEFAULT_EED 1
/*
 Dont let draw on the plotter, but lets to edit
 the functions that are editables in the plotter
*/
#define HISTOGRAM 2

class pGraphicalFunction;
//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------


class pGraphicalFunction: public pPlotterLayer
{
public:

	//constructor 
	pGraphicalFunction(wxString name= wxEmptyString, int flags= mpALIGN_RIGHT);

	~pGraphicalFunction( );
	
	//---------------------------
	//Virtual Mehods
	//---------------------------

	/**
	 Get the value of the traslation
	in the x-axis
	*/
	virtual int getXTraslation()
	{
		return xTraslation;
	}




	/**
	 Get the type of the curve
	 1=normal function
	 2=Histogram
	*/
	virtual int getmType()
	{
		return mType;
	}

	/**
	 Get the type of the curve
	 1=piecewise functio
	 2= smooth
	*/
	virtual int vGetType()
	{
		return _type;
	}

	/**
	 Get _offsetX and _offsetY
	*/

	virtual void getOffsets(int &offsetX,int &offSetY )
	{
		offsetX=(int)_offsetX;
		offsetY=(int)_offsetY;
	}
	
	/*
	* Get the factor zoom
	*/
	virtual void getFactorZoom(float & fz)
	{
		fz=factorZoom;
	}


	/*
	* Get the value of fromWindow
	*/
	virtual void getFromWindowV(bool &fw)
	{
		fw=fromWindow;
	}


	/**
	* if the function that is drawing is the actual
	*/
	virtual void getIfActual(bool &actual)
	{
		actual=ifActual;
	}

	/**
	* get the max of the function in x and y
	*/
	virtual void getMax(int & maxX, int &maxY)
	{
		maxX=(int)getMaxX();
	    maxY=(int)getMaxY();
	}
	/**
	* get the maxShowed of the function in x and y
	*/
	virtual void getMaxShowed(int & maxX, int &maxY)
	{
		maxX=(int)getMaxXShowed();
		maxY=(int)getMaxYShowed();
	}
	/**
	* get the minShowed of the function in x and y
	*/
	virtual void getMinShowed(int & minX, int &minY)
	{
		minX=(int)getMinXShowed();
		minY=(int)getMinYShowed();
	}

	/**
	* Get screens of the function
	*/
	virtual void getScreens(int & scrX, int & scrY)
	{
      scrX=screenX;
	  scrY=screenY;
	}

	/**
	* Set screens value
	*/
	virtual void setScreens(int scrX,int scrY)
	{
		screenX=scrX;
		screenY=scrY;			
	}
	
	/**
	* Let us know the scale of the function
	*/
	virtual void getScales(double & scaleX,double & scaleY)
	{
		scaleX=_scaleX;
		scaleY=_scaleY;
	}
	
	
	/**
	* Let us Know if the user has finished the drawing
	* that starts before.
	*/

	virtual void getDrawing(bool &draw)
	{
		draw = drawing;
	}

	/**
	Let us Know if the user want to see the points of the function
	of other color than the color of the lines
	*/
	virtual void ifShowPoints(bool & show)
	{
		show = showPointsF;
	}

	/**
	*Rewind 
	*/
	virtual void Rewind()
	{
				
		node = logicFunction->GetPointAt(0);
		
	}

	/** Get locus value for next N.
	Override this function in your implementation.
	@param x Returns X value
	@param y Returns Y value
	*/
	virtual bool GetNextXY(double & x, double & y) 
	{
		if(node)
		{
			pFunctionPoint* p=(pFunctionPoint*)node->GetData();
			x=p->getRealX();
			y=p->getRealY();
			node=node->GetNext();
			return true;
		}
		return false;
	}



//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	/**
	Get Point list of the funcion
	@param return points
	*/
	virtual void GetPoints(wxList &points)
	{
		logicFunction->GetPoints(points);
		//points = realPoints;
	}  
#else
	/**
	Get Point list of the funcion
	@param return pointsPtr
	*/
	virtual wxList* GetPointsPtr()
	{
		return logicFunction->GetPointsPtr();
	}  
#endif



	/**
	Get the point where the user
	made a click
	*/
	virtual void getMousePoint(int &x,int &y)
	{
		x = mousePoint.x;
		y = mousePoint.y;
	}

	/**
	* Get the number of points of the function
	*/
	virtual void getSize(int &size)
	{
		size=getSizePoints();
	}

	/**
	* this method gets the direction of the drawing
	*/
	virtual void getDirection(bool &dir)
	{		
		logicFunction -> getDirection (dir);
	}

	//---------------------------
	// Methods
	//---------------------------
	/*
	* validate if the function has that point in a sensible area returning the index where the point was found or -1 if is in not part of the function: define the sensible area is  
	* x1-validPointRange<x<x1+validPointRange y1-validPointRange<y<y1+validPointRange
	*/
	int validPointOnFunction(wxPoint realPoint);

	//returns the index in the list of the point  
	int getIndexOf(wxPoint realpoint);

	/*
	* This metohd returns the node of the point that is the movingPointIndex position in the list of points.
	* @param: int movingPointIndex, Is the index value of the searched node.
	* @return: Return a pointer to the node corresponding to the index value by parameter.
	*/
	wxNode* GetPointAt( int movingPointIndex);

	/*
	* Includes a point between two existing points of the this function. The new point (x,y) was not defined when the function was created.
	*@ return Returns true is the point was succcesfully added to the funcion.
	*/
	bool AddNewPoint(int x,int y);

	/**
	* this method add a new logical point to the function, this point is one of those used to draw the function
	*/
	bool AddPoint(int aX, int aY,bool order=true);

	/**
	* deletes the point given by the  user  from the collection of logical points of the function
	*/
	bool DeletePoint(int aX, int aY);

	/**
	* Change de coordinates of the given point if it is possible and return the result of the invoked action. True if it was possible to do the change.
	*/
	bool changePoint(wxPoint newCoords, int movingIndexPoint);

	/**
	* Evaluates if the given point belongs to the function.
	*/
	//bool hasPoint(wxPoint aAPoint);

	/**
	* Returns the real x values of the control points of the function. It dont includes the points calculated by interpolation.
	*/
	double * getX_RealValues();

	/**
	* Returns the real y values of the control points of the function. It dont includes the points calculated by interpolation.
	*/
	double* getY_RealValues();
	/*
	* This method orders the list of points taking into account that the last appended node in the list (realPoint) is the only one disordered.
	* @return Returns true if the last point included has a valid value for x and was ordered, according to the definition of function.
	*/
	bool orderPoints();

	/**
	* This method get a pointer to the node in the real points list that is inmediately previous to the searched by parameter.
	* @pre The seached point (realX, realY) is not the first point of the list.
	* @param realX
	* @param realY 
	*/
	//wxNode * findPreviousNodeTo( int realX, int realY );

	/**
	* Deletes a point of the function given its index 
	*/
	bool deletePointAt(int index);
	/*
	* Returns the number of points that the function
	* has
	*/
	int getSizePoints();
	/*
	* Set the scales of the function in x and y
	*/
	void setScales();

	//----------------------------------
	// Asking if it has a point (x,y)
	//----------------------------------

	/*
	* returns true if the point is along the function
	* false otherway
	*/
	bool isInFunction(int x, int y);
	/*
	* give us the point that is in the function and is exactly before
	* the point we are giving
	*/
	wxNode* getBefore(pFunctionPoint* point);
	/*
	* Returns true if the point is in the line
	*/
	bool isInLine(pFunctionPoint* before,pFunctionPoint* next, pFunctionPoint* point);
	/**
	* give us the value of y in the line define by the arguments
	*/
	double interpolateY(double m, int x1,int y1,int x);
	/*
	 * Set Up startPoint, endPoint, maxY,maxX points	
	*/
	void setUp();
	//----------------------------
	// Spline Methods
	//----------------------------
	/*
	* clear the spline vectors
	*/
	void clearSplineVectors();


	/*
	Initiliaze xSpline and ySpline vectors
	*/
	void initializeSplines();
	
	/*
	Add the (x,y) points of the function to the 
	spline
	*/
	void addSplinesPoints();
	
	/*
	 This Method adds the point calculated by
	 the splines to the vectors
	*/
	void initializeSplineVectors();
	
	/*
	 get the spline point for t, in xKSpline and yKSpline
	*/
	void GetSplinePoint(double t, double &x, double &y); 
	/*
	 returns the xSpline to plotter
	*/
	virtual std::vector<double> getXSpline()
	{
		return xSpline;
	}
	/*
	 returns the ySpline to plotter
	*/
	virtual std::vector<double> getYSpline()
	{
		return ySpline;
	}


	/**
	Gets the x-offset of the zoom
	in pixels
	*/
	virtual int getOffsetPixelsXv()
	{
		return offsetPixelX;
	}	
	
	/**
	Gets the offset of the zoom
	in pixels
	*/
	virtual int getOffsetPixelsYv()
	{
		return offsetPixelY;
	}

	//-----------------------
	// Persistence
	//-----------------------

	/*
	 Save the points of the function
	*/
	void save(wxString fileName);
	/*
	 Load the points of a function 
	*/
	void load(wxString fileName);

    //------------------------------
	// Getters and Setters
	//------------------------------

	//set if the function has to draw the points  
	void SetShowPoints(bool showPoints);

	//get the paramater showPointsF
	bool getShowPoints();

	void setScreenX(int scrX);

	int getScreenX();

	void setScreenY(int scrY);

	int getScreenY();
	
	void setStartX(double aStartX);

	double getStartX();

	void setStartY(double aStartY);

	double getStartY();

	void setEndX(double aEndX);

	double getEndX();

	void setEndY(double aEndY);

	double getEndY();

	void setScaleX(double aScaleX);

	double getScaleX();

	void setScaleY(double aScaleY);

	double getScaleY();

	void setMinX(double aMinX);

	double getMinX();

	void setMinY(double aMinY);

	double getMinY();
	
	void setMaxX(double aMaxX);

	double getMaxX();

	void setMaxY(double aMaxY);

	double getMaxY();

	void setOffsetX(double aOffsetX);

	double getOffsetX();

	void setOffsetY(double aOffsetY);

	double getOffsetY();

	void setType(int aType);

	int getType();

	int getValidPointRange();

	void setValidPointRange(int theRange);

	void SetDrawing(bool d)
	{
		drawing = d;
	}
	//get if the function is being drawed
	bool GetDrawing()
	{
		return drawing;
	}

	//set the mouse point
	void SetMousePoint(wxPoint p)
	{ 
		mousePoint = p;
	}
	//get the mousePoint
	wxPoint getMousePoint()
	{
		return mousePoint;
	}
	/**
	* actual
	*/
	void setActual(bool act);

	bool getActual();

	/**
	* SCALE WAY
	* DEFECT_SCALE 1
	* MAX_SCALE 2
	* USER_SCALE 3
	*/
	void setScaleWay(int typeS);

	int  getScaleWay();
	
	/**
	* set fromWindow: it is set to true if the
	* function was created interactively
	*/
	void setFromWindow(bool w)
	{
		fromWindow=w;
	}
	
	/*
	* Get the value of fromWindow
	*/
	bool getFromWindow()
	{
		return fromWindow;
	}
	/*
	*  Set factor zoom
	*/
	void setFactorZoom(float factor)
	{
		factorZoom=factor;
	}
	/*
	* Set editable
	*/
	void setEditable(bool edit)
	{
		editable=edit;
	}
	/**
	* Get editable
	*/
	bool getEditable()
	{
		return editable;
	}

	//----------------------------
	// Zoom
	//----------------------------

	/* 
	 * Get boolean zoom
	 */
	bool getZoomB()
	{
		return zoomIn;
	}
	/* *
	 * Set boolean zoom
	 * @param z: the new value
	 */
	void setZoomIn(bool z)
	{
		zoomIn=z;
	}
	/**
	* Set the initial drawing point
	* @param pFunctionPoint* initialPoint
	*/
	void setInitialDrawPoint(pFunctionPoint* initialPoint)
	{
		initialDrawingPoint=initialPoint;	
	}
	/**
	* Get the initial drawing point
	* @return initialDrawingPoint
	*/
	pFunctionPoint* getInitialDrawPoint()
	{
		return initialDrawingPoint;	
	}
	/**
	* Set the final drawing point
	* @param pFunctionPoint* finalPoint
	*/
	void setFinalDrawPoint(pFunctionPoint* finalPoint)
	{
		finalDrawingPoint=finalPoint;	
	}
	/**
	* Get the final drawing point
	* @return finalDrawingPoint
	*/
	pFunctionPoint* getFinallDrawPoint()
	{
		return finalDrawingPoint;	
	}
	/**
	This method set the initial point and the final point of drawing
	according with the width of the square around the point clicked
	@param clickedX
	@param clickedY
	@param width: width of the square
	*/
	
	void zooming(int clickedX,int clickedY,int width);
	
	/*
	* This method sets the offset 
	*/
	void setOffsets(int offx,int offy);
	
	/*
	*  This method sets the minShowedX 
	*  and the minShowedY, accordig to the offset in
	*  x-axis and y-axis respectively
	*  pre: _offsetX>=0,_offsetY>=0
	*/
	void setMinShowed();

	/**
	Get the minX Showed
	*/
	int getMinXShowed()
	{
		return minShowedX;
	}
	/**
	Get the minY Showed
	*/
	int getMinYShowed()
	{
		return minShowedY;
	}
	/**
	Get the maxX Showed
	*/
	int getMaxXShowed()
	{
		return maxShowedX;
	}
	/**
	Get the maxY Showed
	*/
	int getMaxYShowed()
	{
		return maxShowedY;
	}
	/**
	 Set the minShowedX
	*/
	void setMinShowedX(int msx)
	{
		minShowedX=msx;
	}
	/**
	 Set the minShowedY
	*/
	void setMinShowedY(int msy)
	{
		minShowedY=msy;
	}
	/**
	 Set the maxShowedX
	*/
	void setMaxShowedX(int msx)
	{
		maxShowedX=msx;
	}
	/**
	 Set the minShowedY
	*/
	void setMaxShowedY(int msy)
	{
		maxShowedY=msy;
	}

	//------------------------
	// Offsets in pixels 
	//------------------------
	
	/**
	Gets the x-offset of the zoom
	in pixels
	*/
	int getOffsetPixelsX()
	{
		return offsetPixelX;
	}	
	
	/**
	Gets the offset of the zoom
	in pixels
	*/
	int getOffsetPixelsY()
	{
		return offsetPixelY;
	}
	/**
	 Set the x-offset of the zoom
	*/
	void setOffsetPixelX(int offX)
	{
		offsetPixelX=offX;
	}
	/**
	 Set the y-offset of the zoom
	*/
	void setOffsetPixelY(int offY)
	{
		offsetPixelY=offY;
	}	

	

	/*
	* Sets the color points of the function by teh given parameter
	* @param colorVector Is the color points vector to set
	*/
	void setColorPoints(std::vector<pColorPoint *> &colorVector);

	/*
	* Gets the color points of the function in the given parameter
	* @param colorVector Is the color points list to get the points
	*/
	void getColorPoints(std::vector<pColorPoint *> &colorVector);
	/*
	 Setter the mType
	*/
	void setmType(int mt)
	{
		mType=mt;
	}
	//-----------------------
	//TRASLATION
	//-----------------------
	/**
	 Set the value of the traslation
	 in the x-axis
	 @param xT value in pixels of the traslation in x-axis
	*/
	void setXTraslation(int xT)
	{
		 xTraslation=xT;
	}
	


private:

	/**
	* Represents the logical function asociated to this graphical function.
	*/
	pLogicalFunction* logicFunction;
	/**
	* If the function has to showpoints
	*/
	bool showPointsF;

	/**
	* Is the initial discrete point on x axis of the drawed function.
	*/
	double _startX;
	/**
	* Is the initial discrete point on y axis of the drawed function.
	*/
	double _startY;
	/**
	* Is the last discrete point on x axis of the drawed function.
	*/
	double _endX;
	/**
	* Is the last discrete point on y axis of the drawed function.
	*/
	double _endY;
	/**
	* Is the x-scale percentage according to the context device.
	*/
	double _scaleX;
	/**
	* Is the y-scale percentage according to the context device.
	*/
	double _scaleY;
	/**
	* Is the minimun x-real value reacheable by the function.
	*/
	double _minX;
	/**
	* Is the minimun y-real value reacheable by the function.
	*/
	double _minY;
	/**
	* Is the maximun x-real value reacheable by the function.
	*/
	double _maxX;
	/**
	* Is the maximun y-real value reacheable by the function.
	*/
	double _maxY;
	/**
	* Is the logical x-offset of the drawed function.
	*/
	double _offsetX;
	/**
	* Is the logical y-offset of the drawed function.
	*/
	double _offsetY;
	/**
	* Is the way of how points are going to be connected. It could be smooth, line.
	*/
	int _type;
	/**
	* The list of the function points
	*/
	wxList realPoints;
	/*
	* The list of the color points of the function associated to the color bar
	*/
	std::vector<pColorPoint *> f_colorPoints;

	/**
	*  node of the realPoints where are we
	*/
	wxNode* node;
	/**
	* Number that determines the radius range for the valid area the point (sensible radius). Default value 5.
	*/
	int validPointRange;

	/**
	* Indicates if the user is drawing the function
	*/
	bool drawing; 

	/**
	* this is for the graphical function
	* Mouse Point
	*/
	wxPoint mousePoint;

	/**
	* The size of the screen in X
	*/
	int screenX;
	
	/**
	* The size of the screen in Y
	*/
	int screenY;
	/**
	  if is the actual
	*/
	bool ifActual;
	
	/**
	 the way we scale
	 DEFECT_SCALE 1
	 MAX_SCALE 2
	 USER_SCALE 3
	*/
	
	int scaleWay;

	/**
	 if the function comes from window
	*/
    bool fromWindow;
	/**
	* factorZoom
	*/
	float factorZoom;
	/**
	* The function is editable
	*/
	bool editable;
	 /**
	 * if the user did a zoom in/out
	 */
	bool zoomIn;
	/**
	* initial drawing point
	*/
	pFunctionPoint* initialDrawingPoint;
	/**
	* final drawing point
	*/
	pFunctionPoint* finalDrawingPoint;
	/**
	 Minimum point showed to the user
	 (zoom)X
	*/
	int minShowedX;
	/**
	 Maximum point showed to the user
	 (zoom)X
	*/
	int maxShowedX;
	/**
	 Minimum point showed to the user
	 (zoom)Y
	*/
	int minShowedY;
	/**
	 Maximum point showed to the user
	 (zoom)X
	*/
	int maxShowedY;
	
	
	/*
	 Vectors where the spline is stored
	*/
	std::vector<double> xSpline;
	
	std::vector<double>	ySpline;
	
	/*
	  Kochanek splines
	*/
	vtkKochanekSpline* xKSpline;

	vtkKochanekSpline* yKSpline;
	
	
	/**
	 offset in pixels where the user has clicked
	 before changing the scale
	*/
	int offsetPixelX;
	int offsetPixelY;
	/*
	 type of the meaning of the function
	 DEFAULT=1; the  function  has no meaning
	 HISTOGRAM=2. The function represents an histogram
	*/

	int mType;

	/*
	 is use for lets the user move the function
	*/
	int xTraslation;

	DECLARE_CLASS (pGraphicalFunction)
};

#endif


