/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*
#ifndef __pHistogram_h__
#define __pHistogram_h__

// --------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// --------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
*/

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------

//---------------------
// VTK
//---------------------

#include <vtkVersionMacros.h>
#include "vtkImageData.h"
#include "vtkMetaImageReader.h"


//-----------------
// C++
//-----------------
#include <iostream>
#include <string>
#include <vector>
//--------------------------------------------------------------------------------------------
// Class definition
//--------------------------------------------------------------------------------------------

class pHistogram //:public wxObject
{

	//----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------
	public:
		
		/*
		 Constructor
		*/
		pHistogram(std::string filePath);
		/*
		 Constructor
		*/
		pHistogram(vtkImageData* imageData);
		~pHistogram();
		/*
		 @param filePath: is the path where the image is 
		*/
		void setImagePath(std::string filePath);
		/*
		 Return the points of the histogram of the image
		*/
		std::vector <int> getPoints();
		/*
		 Calculate the histogram and save it in the attribute points
		 it is used if the user had given the file's path
		*/
//private:	
		void buildHistogram();
		/*
		 Calculate the histogram and save it in the attribute points
		 it is used if the user had given the imageData
		*/
		void buildHistogram(vtkImageData* imageData);
		/*
		getting ready the points
		*/
		void initializePoints(int xDimension);
		/*
		constructing the histogram
		*/
		void setPoints(vtkImageData* imageData);
		/*
		Returns the poins of the histograms
		*/
		vtkImageData* getHistogram();
		/*
		  hash por getting the index for the histogram vector of the original
		  image
		*/
		int getIndex(double gValue);
		/*
		Setting the size
		*/
		void setSize(int nSize);
		/*
		 Get Image Size
		*/
		int getImageSize();
		/*
		 Get Size of the histogram
		*/
		int getSize();
		/*
		 Get the maximum value of grey of the histogram
		*/
		int getMaximumLevelOfGrey();
		/*
		 Get the minimum value of grey of the histogram
		*/
		int getMinimumLevelOfGrey();
		/*
		get a point of the Histogram
		given the grey value
		*/
		int getHistogramPoint(int gValue);


	//----------------------------------------------------------------------------------------
	// Attributes declaration
	//----------------------------------------------------------------------------------------
	private: 
		/*
		 Points of the histogram of 
		 the image
		*/
		vtkImageData* points;
		/*
		 The path of the image
		*/
		std::string path;
		/*
		 the size of histogram vector
		*/
		int size;
		/*
		 Maximum Level of grey
		*/
		double maxLevelOfGrey;
		/*
		 Minimum Level of grey
		*/
		double minLevelOfGrey;
		/*
		 image size
		*/
		long int sizeImage;

	//DECLARE_CLASS (pHistogram)
};

//#endif


