/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __pLogicalFunction_h__
#define __pLogicalFunction_h__

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------

#include "pFunctionPoint.h"
#include <iostream>
#include <fstream>
#include <string>



class pLogicalFunction;
//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------
#define MAX_POINTS 50

//if your are going to change se sensible region  you have to change MOVE in pPlotterLayer
#define SENSIBLE_REGION 5


class pLogicalFunction: public wxObject
{
public:

	//----------------------------------------------------------------------------
	// Constructors
	//----------------------------------------------------------------------------
	pLogicalFunction( );

	~pLogicalFunction( );
	
	/**
	*Rewind 
	*/
	/*virtual void Rewind()
	{
		node = realPoints.GetFirst();
	}
	*/
	
	/** Get locus value for next N.
	Override this function in your implementation.
	@param x Returns X value
	@param y Returns Y value
	*/
	/*virtual bool GetNextXY(double & x, double & y) 
	{
		if(node)
		{
			pFunctionPoint* p=(pFunctionPoint*)node->GetData();
			x=p->getRealX();
			y=p->getRealY();
			node=node->GetNext();
			return true;
		}
		return false;
	}
	*/


//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	/**
	Get Point list of the funcion
	@param return points
	*/
	/*virtual*/
	void GetPoints(wxList &points)
	{
		points = realPoints;
	}  
#else
	/**
	Get Point list of the funcion
	@param return pointsPtr
	*/
	/*virtual*/
	wxList* GetPointsPtr()
	{
		return &realPoints;
	}  
#endif


	/*
	* validate if the function has that point in a sensible area returning the index where the point was found or -1 if is in not part of the function: define the sensible area is  
	* x1-validPointRange<x<x1+validPointRange y1-validPointRange<y<y1+validPointRange
	*/
	int validPointOnFunction(wxPoint realPoint);

	//returns the index in the list of the point  
	int getIndexOf(wxPoint realpoint);

	/*
	* This metohd returns the node of the point that is the movingPointIndex position in the list of points.
	* @param: int movingPointIndex, Is the index value of the searched node.
	* @return: Return a pointer to the node corresponding to the index value by parameter.
	*/
	wxNode* GetPointAt( int movingPointIndex);

	/*
	* Includes a point between two existing points of the this function. The new point (x,y) was not defined when the function was created.
	*@ return Returns true is the point was succcesfully added to the funcion.
	*/
	bool AddNewPoint(int x,int y);

	/**
	* this method add a new logical point to the function, this point is one of those used to draw the function
	*/
	bool AddPoint(int aX, int aY,bool order=true);

	/**
	* deletes the point given by the  user  from the collection of logical points of the function
	*/
	bool DeletePoint(int aX, int aY);

	/**
	* Change de coordinates of the given point if it is possible and return the result of the invoked action. True if it was possible to do the change.
	*/
	bool changePoint(wxPoint newCoords, int movingIndexPoint);

	/**
	* Evaluates if the given point belongs to the function.
	* IS NO USED
	*/
	//bool hasPoint(wxPoint aAPoint);

	/**
	* Returns the real x values of the control points of the function. It dont includes the points calculated by interpolation.
	*/
	double * getX_RealValues();

	/**
	* Returns the real y values of the control points of the function. It dont includes the points calculated by interpolation.
	*/
	double* getY_RealValues();
	/*
	* This method orders the list of points taking into account that the last appended node in the list (realPoint) is the only one disordered.
	* @return Returns true if the last point included has a valid value for x and was ordered, according to the definition of function.
	*/
	bool orderPoints();

	/**
	* This method get a pointer to the node in the real points list that is inmediately previous to the searched by parameter.
	* @pre The seached point (realX, realY) is not the first point of the list.
	* @param realX
	* @param realY
	* IS NOT USED
	*/
	//wxNode * findPreviousNodeTo( int realX, int realY );

	/*
	 * sets the start point of the function
	 */
	void  setStartPoints();

	/*
	 * sets the end point of the function
	 */
	void setEndPoints();

	/*
	 * set the max value in x and y between all the points of the function
	 */
	void setMaxPoints();


	/*
	 * set the min value in x and y between all the points of the function
	 */
	void setMinPoints();
	/*
	 * Set Up startPoint, endPoint, maxY,maxX points	
	*/
	void setUp();


	//set if the function has to draw the points  
	//void SetShowPoints(bool showPoints);

	//get the paramater showPointsF
	//bool getShowPoints();

	//-----------------------
	// Persistence
	//-----------------------

	/*
	 Save the points of the function
	*/
	void save(wxString fileName);
	/*
	 Load the points of a function 
	*/
	void load(wxString fileName);

	//----------------------------
	//Getters and Setters
	//----------------------------

	void setStartX(double aStartX);

	double getStartX();

	void setStartY(double aStartY);

	double getStartY();

	void setEndX(double aEndX);

	double getEndX();

	void setEndY(double aEndY);

	double getEndY();

	void setScaleX(double aScaleX);

	double getScaleX();

	void setScaleY(double aScaleY);

	double getScaleY();

	void setMinX(double aMinX);

	double getMinX();

	void setMinY(double aMinY);

	double getMinY();

	void setMaxX(double aMaxX);

	double getMaxX();

	void setMaxY(double aMaxY);

	double getMaxY();

	void setOffsetX(double aOffsetX);

	double getOffsetX();

	void setOffsetY(double aOffsetY);

	double getOffsetY();

	void setType(int aType);

	int getType();

	int getValidPointRange();

	void setValidPointRange(int theRange);

	/**
	* Deletes a point of the function given its index 
	*/
	bool deletePointAt(int index);
	/*
	* Returns the number of points that the function
	* has
	*/
	int getSizePoints();

	void getDirection(bool &dir);



private:

	/**
	* Is the initial discrete point on x axis of the drawed function.
	*/
	double _startX;
	/**
	* Is the initial discrete point on y axis of the drawed function.
	*/
	double _startY;
	/**
	* Is the last discrete point on x axis of the drawed function.
	*/
	double _endX;
	/**
	* Is the last discrete point on y axis of the drawed function.
	*/
	double _endY;
	/**
	* Is the x-scale percentage according to the context device.
	*/
	double _scaleX;
	/**
	* Is the y-scale percentage according to the context device.
	*/
	double _scaleY;
	/**
	* Is the minimun x-real value reacheable by the function.
	*/
	double _minX;
	/**
	* Is the minimun y-real value reacheable by the function.
	*/
	double _minY;
	/**
	* Is the maximun y-real value reacheable by the function.
	*/
	double _maxX;

	/**
	* Is the maximun y-real value reacheable by the function.
	*/
	double _maxY;

	/**
	* Is the logical x-offset of the drawed function.
	*/
	double _offsetX;
	/**
	* Is the logical y-offset of the drawed function.
	*/
	double _offsetY;
	/**
	* Is the way of how points are going to be connected. It could be smooth, line.
	*/
	int _type;
	/**
	* The list of the function points
	*/
	wxList realPoints;

	/**
	*  x-values
	*/
	double x_Values[MAX_POINTS];
	/**
	*  y-values
	*/
	double y_Values[MAX_POINTS];
	/**
	*  node of the realPoints where are we
	*/
	//wxNode* node;
	
	/**
	* Number that determines the radius range for the valid area the point (sensible radius). Default value 5.
	*/
	int validPointRange;

	/**
	* Indicates the way the function is being drawed when defining it. So that it is true if the direction is from left-to-right, and false if it is from right-to-left.
	* It is initialized when the second point is included in the funcion.
	*/
	bool leftToRigthDef;

	/**
	* Indicates if the user is drawing the function
	*/
	//bool drawing;


	DECLARE_CLASS (pLogicalFunction)
};

#endif


