/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __pPlotterLayer_h__
#define __pPlotterLayer_h__
// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------
#include "mathplot.h"
#include "pFunctionPoint.h"
#include <vector>

#define MAX_POINTS 50
#define MOVE 5


//using namespace std;
//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------
class creaMaracasVisu_EXPORT pPlotterLayer: public mpLayer 
{

public:
	/** @param name  Label
	@param flags Label alignment, pass one of #mpALIGN_NE, #mpALIGN_NW, #mpALIGN_SW, #mpALIGN_SE.
	*/
	pPlotterLayer(wxString name = wxEmptyString, int flags = mpALIGN_NE);
	/*
	 it define the first point of the polygon for be drawing
	 returs true if the first and second point of the polygon are setted
	*/
	bool initializePolygon(wxPoint* points,double x1, double y1,double x2, double y2);
	/*
	Draw the line from (x1,y1) to (x2,y2) only passing by the 
	positive points in the line
	*/
void draw(wxDC & dc,mpWindow & w,double x1,double y1,double x2,double y2, int orgy);
	
	/**
	* Draw the function with th spline points
	*
	*/
	void drawSplineCurve(wxDC & dc,mpWindow & w, int orgy);
	
	/**
	* Draw the line between the last point of the function
	* and the position of the mouse
	*/
	void drawLineToMousePoint(wxDC & dc,mpWindow & w, int orgy);
	/**
	* Draw le lines between the points of the function
	*/
	void drawFunction(wxDC & dc,mpWindow & w, int orgy);
	/**
	*  Draw the points of the function
	*/
	void drawPoints(wxDC & dc,mpWindow & w, int orgy );
	
	/**
	 Get the value of the traslation
	in the x-axis
	*/
	virtual int getXTraslation()
	{
		return -1;
	}
	/**
	 Get the type of the curve
	 1=normal function
	 2=Histogram
	*/
	virtual int getmType()
	{
		return -1;
	}
	/**
	* get the maxShowed of the function in x and y
	*/
	virtual void getMaxShowed(int & maxX, int &maxY)
	{
	}
	/**
	* get the minShowed of the function in x and y
	*/
	virtual void getMinShowed(int & minX, int &minY)
	{
	}
	
	/**
	Gets the x-offset of the zoom
	in pixels
	*/
	virtual int getOffsetPixelsXv(){return -1;}	
	
	
	/**
	Gets the Y-offset of the zoom
	in pixels
	*/
	virtual int getOffsetPixelsYv(){ return -1;}

	
	/*
	 returns the xSpline to plotter
	*/
	virtual std::vector<double> getXSpline()
	{ 
		std::vector<double> v;
		return v;
	}
	/*
	 returns the ySpline to plotter
	*/
	virtual std::vector<double> getYSpline()
	{ 
		std::vector<double> v;
		return v;
	}

	/**
	 Get the type of the curve
	 1=piecewise functio
	 2= smooth
	*/
	virtual int vGetType()
	{ return -1;}


	/**
	 Get _offsetX and _offsetY
	*/

	virtual void getOffsets(int &offsetX,int &offSetY )
	{}

	/*
	* Get the factor zoom
	*/
	virtual void getFactorZoom(float & fz){}
	/**
	* if the function that is drawing is the actual
	*/
	virtual void getIfActual(bool &actual){}
	
	
	/**
	* get the max of the function in x and y
	*/
	virtual void getMax(int & maxX, int &maxY){}

	/**
	* Get screens of the function
	*/
	virtual void  getScreens(int & scrX, int & scrY){}

	/**
	* Set screens value
	*/
	virtual void setScreens(int scrX,int scrY){}

	/**
	* Let us know the scale of the function
	*/
	virtual void getScales(double & scaleX,double & scaleY){}

	/**
	*Rewind the value of node
	*/
	virtual void Rewind(){}

	/** Get locus value for next N.
	Override this function in your implementation.
	@param x Returns X value
	@param y Returns Y value
	*/
	virtual bool GetNextXY(double & x, double & y){return false;}

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	/**
	Get Point list of the funcion
	@param return points
	*/
	virtual void GetPoints(wxList &points){}
#else
	/**
	Get Point list of the funcion
	@param return points
	*/
	virtual wxList* GetPointsPtr(){ return NULL; }
#endif


	/** Layer plot handler.
	This implementation will plot the locus in the visible area and
	put a label according to the aligment specified.
	*/
	virtual void Plot(wxDC & dc, mpWindow & w);
	/**
	Let us Know if the user want to see the points of the function
	of other color than the color of the lines
	*/
	virtual void ifShowPoints(bool & show){}

	/**
	* Let us Know if the user has finished the drawing
	* that starts before.
	*/
	virtual void getDrawing(bool &draw){}
	/*
	* Gets the point of the mouse where the user is
	*/
	virtual void getMousePoint(int &x,int &y){}
	/**
	* this method gets the direction of the drawing
	*/
	virtual void getDirection(bool &dir){}
	/**
	* Get the number of points of the function
	*/
	virtual void getSize(int &size){};

protected:
	int m_flags; //!< Holds label alignment

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	/*
	* Points of the function thats is drawing
	*/
	wxList points;
#else
	//  use GetPointsPtr()
#endif

	/*
	* the scale in x, with wich it must draw
	*/
	double scaleX;
	/*
	* the scale in y, with wich it must draw
	*/
	double scaleY;

	/**
	* offset X
	*/
	int offsetX;
	
	/**
	* offset Y
	*/
	int offsetY;
	

	DECLARE_CLASS (pPlotterLayer)
};

#endif


