/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __pPlotterWindow_h__
#define __pPlotterWindow_h__

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------


#include "pPlotterLayer.h"
#include "pGraphicalFunction.h"
#include "mathplot.h"
#include "marTypes.h"



/** Command IDs used by pPlotterWindow */
enum
{
	pwID_ADDPOINT = 2010,    //!< add a point to the function
	pwID_DELPOINT,       //!< delete a point of the function
	pwID_SHOWPOINTS,  //!<shows the points that the function has
	pwID_STARTDRAWING, //!<let to the user to start drawing the curve
	pwID_DELFUNCTION, //!<delete a function that is in the plotter
	pwID_STOPDRAWING,//!<Stops the drawing of the function
	pwID_ADDNEWPOINT,//!<add a new point to the function.
	pwID_NOSHOWPOINTS, //!<No show the points of the function.
	pwID_MYZOOMIN,//!<Zoom in the function
	pwID_MYZOOMOUT,//!<Zoom out the points of the function.
	pwID_SPLINE,//!<Spline the actual curve.
	pwID_LINE,//!<Piecewise the actual curve.
	pwID_SAVE,//!<Save the function in a .txt file.
	pwID_LOAD, //!<Load the function from a .txt file.
	pwID_CHANGECOLOR, //!<Change the color of the function
	pwID_TRASLATEACTUALFUNCTION, //!<move the actual function
	pwID_LEFTUP//!<listening a click up

};


wxDECLARE_EVENT(wxEVT_PPLOTTER, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_PPLOTTER_CHANGED_FUNCTION, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_PPLOTTER_POINT_MOVE, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_PPLOTTER_POINT_ADD, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_PPLOTTER_POINT_DELETE, wxCommandEvent);
wxDECLARE_EVENT(wxEVT_PPLOTTER_GUIDELINES, wxCommandEvent);




#define MAX_FUNCTIONS 7
/**
 this scale, scales each function with its maximum x, and maximum y
 in its points
*/
#define DEFAULT_SCALE 1
/**
 this scale with the maximun x  and y of all the functions defined
*/
#define MAX_SCALE 2
/**
 this scales with the scale giving by the user of the widget
*/
#define USER_SCALE 3

/*
 Types of Plotter
*/
/*
 Lets to the user to plot any number of the
 functions
*/
#define DEFAULT_PLOTTER 1
/*
 Dont let draw on the plotter, but lets to edit
 the functions that are editables in the plotter
*/
#define HISTOGRAM_PLOTTER 2
/**
* THE FACTOR TO ZOOM (IN,OUT)
*/
//#define ZOOM_FACTOR 2
//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT pPlotterWindow: public mpWindow
{
public:
	/**
	* Constructors and destructor
	*/         
	pPlotterWindow( wxWindow *parent, wxWindowID id,
		const wxPoint &pos = wxDefaultPosition,
		const wxSize &size = wxDefaultSize,
		int flags = 0);
	~pPlotterWindow();
	
	//----------------------------
	//Handling Options Menu
	//----------------------------
	/*
	if any parameter is true, is going to be remove from the popUp menu
	*/
	void setPopUpMenu(bool startD,bool stopD,bool smooth,bool line, bool zoomIn,
					  bool zoomOut,bool showPoints,bool noShowPoints,bool changeColor, bool addP,
					  bool delPoint,bool load,bool save);


	//-------------------------------
	//Traslating the actual function
	//-------------------------------
	/*
		Manipulating clicks on the plotter
	*/
	void onLeftUp(wxMouseEvent& event);
	
	/*
	 Move the actual function  when the user
	 is moving the mouse
	*/
	void onMoveFunction(wxCommandEvent& aEvent);


	/**
	* Change the color of the function
	*/
	void onChangeColor(wxCommandEvent& aEvent);


	/**
	* Load the function from a .txt file
	*/
	void onLoad(wxCommandEvent& aEvent);

	/**
	* Save the points of the function in a .txt file
	*/
	void onSave(wxCommandEvent& aEvent);


	/**
	* Change the type of drawing of the actual function
	* to a piecewise function
	*/
	void onLine(wxCommandEvent& aEvent);


	/**
	* Spline the points of the actual curve
	*/
	void onSplinePoints(wxCommandEvent& aEvent);
	
	
	/**
	* Zoom out the functions
	*/
	void onMyZoomOut(wxCommandEvent& aEvent);

	/**
	* Zoom in the functions
	*/
	void onMyZoomIn(wxCommandEvent& aEvent);

	/**
	* Transform the point clicked  from window
	* to the real value,given by the scale
	*/
	wxPoint getRealPoint(wxPoint pixelPoint);	  

	/**
	* The user doesnt want see the points of the function
	*/
	void onNoShowPoints(wxCommandEvent& aEvent);

	/**
	Stop the drawing of the actual function
	*/
	void onStopDrawing(wxCommandEvent& aEvent);

	/**
	* Adds a point  to the function after the definition of the initial points of the function
	* know this point is  a point of the function
	*
	*/
	void onAddNewPoint(wxCommandEvent& aEvent);

	/**
	* Let to the user to start drawing
	*/
	void onStartDrawing(wxCommandEvent& aEvent);

	/**
	* Listens the event of the mouse when it is moving, this is use to know if the user is moving a pont of the function and in tha way to know when repainting.
	*/
	void onMouseMove(wxMouseEvent& event);

	/**
	* Listens the event mouse left button double click.
	* if the user give us a double click is because he wants to change
	* the actual function to the function that has that point
	*/
	void onChangeActual(wxMouseEvent& event);

	/**
	* Add a new point to the function and then repaint
	*/
	void onAddPoint(wxMouseEvent& aEvent);

	/**
	* Deletes a point of the function and then repaint
	*/
	void onDeletePoint(wxCommandEvent& aEvent);

	/**
	* Shows graphicly the discrete points that the function has
	*/
	void onShowPoints(wxCommandEvent& aEvent);

	/**
	* Changes the type according to the specified number of the type. If the second parameter, the boolean one is true indicates that this action must be done in all the funtion, if not it will be applied only to the actual selected function.
	* IS NOT IMPLEMENTED
	*/
	void changeFuntionType(int aTheType, bool aForAll);

	/**
	* Add a function to the plotter
	* when the function doesnt come from window
	*/
	int addFunction(pGraphicalFunction * function);

	/**
	*  Delete a point of a function
	*  @param point: is the real value that the functon takes, and is gointg to be deleted  
	*/
	bool DeletePointFunction(pGraphicalFunction* function,wxPoint point);

	/**
	* Delete a function of the plotter
	*/
	bool deleteFunction(pGraphicalFunction * f);
	/**
	*  Sets the actual function
	*  @param newActual: new function
	*/
	void  setActualFunction(pGraphicalFunction* newActual);
	/**
	*  Get the actual function
	*/
	pGraphicalFunction* getActualFunction();

	/**
	* Creates and returns a graphical funcion according to the indicated vectors.
	*/
	void InitFunctionForVectors( pGraphicalFunction *ff );
	pGraphicalFunction * getFunctionForVectors( double* vectorX, int sizeX,double * vectorY, int sizeY );
	pGraphicalFunction * getFunctionForVectors( std::vector<double> *vectorX, std::vector<double> *vectorY );

	/*
	 Set the scales according to the size of the window
	 and the maximum given by the user
	*/

	void setActualScales();
	
	

	//erase

	void setmLog(wxTextCtrl *m_log1)
	{
		m_log=m_log1;
	}

	/*
	* Actualizes the view range of the plotter and the actual function
	* @param newMinX Is the min-value to be shown in the x-scale
	* @param newMaxX Is the max-value to be shown in the x-scale
	*/
	void actualizeViewRange(int newMinX, int newMaxX);

		/*
	* Sets the condition for drawing or not the guide lines
	* @param ifDrawing The new condition to assing 
	*/
	void setLineGuidesCondition(bool ifDrawing)
	{		
		drawGuides = ifDrawing;		
	}

	
	/*
	* Gets the condition for drawing or not the guide lines
	* @retval drawGuides The assigned condition
	*/
	bool drawGuideLines()
	{
		return drawGuides;
	}	
	/*
	* Guide lines menu handler method that reacts to the mpID_LINE_GUIDES cimmand event
	* event The corresponding event to handle
	*/
	void OnGuideLines (wxCommandEvent   &event); 

	/*
	 writes in  t information
	*/
	void writeInText(wxString &t)
	{
		t=text;
	}
	
	/*
	 Get a function in the plotter given the index
	*/
	pGraphicalFunction* getFunction(int index);
	
	/*
	  move the functions that the user wants to move
	  and that were setted in functionsToMove
	  @param porcentageMinX:the porcentage that the minShowed
	  of the funcntions have to be move
	  @param porcentageMaxX:the porcentage that the maxShowed
	  of the funcntions have to be move

	*/
	void moveFunctions(float porcentageMinX,float porcentageMaxX);
/**
	* Add a function to the plotter
	* when the function doesnt come from window
	*/
	int addFunctionToMove(pGraphicalFunction * function);

	
private:

	/**
	* Actual Function
	*/
	pGraphicalFunction* actual;
	/**
	* layers
	*/
	wxList functions;

	/**
	* If is drawing the function
	*/
	bool drawing;
	/**
	* Index of the movig point, if the user is moving
	* a poit
	*/
	int movingPointIndex;

	/**
	* the way we scale
	 DEFAULT_SCALE 1
	 MAX_SCALE 2
	 USER_SCALE 3
	*/
	int scaleWay;

	
	/*
		Use to Show Information
	*/

	wxTextCtrl  *m_log;
	wxString	text;

	/*
	  Functions to be move at the same time
	*/
	wxList functionsToMove;
	/*
	 the user is moving the function
	*/
	bool movingFunction;
	/*
	*/
	int initialMovingCLick;

	/*
		saving the initial function
	*/
	std::vector<double> backUpActualVector;
	/*
	wants to move the points of the function
	*/
	bool movingPoints;

	DECLARE_CLASS (pPlotterWindow)
	//----------------------------------------------------------------------------
	// wxWidget macro use declaration for handdling events
	//----------------------------------------------------------------------------
	DECLARE_EVENT_TABLE()
};

#endif


