/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKINTERACTORSTYLEBASEVIEW_H_
#define VTKINTERACTORSTYLEBASEVIEW_H_


#include "wxVtkBaseView.h"
#include <vector>


//class InteractorStyleMaracas;
//#include "InteractorStyleMaracas.h"
class InteractorStyleMaracas;


class creaMaracasVisu_EXPORT vtkInteractorStyleBaseView : public vtkInteractorStyleImage
{
public:
	vtkInteractorStyleBaseView();
	~vtkInteractorStyleBaseView();
	static vtkInteractorStyleBaseView *New();
	virtual void  OnChar();
	virtual void  OnMouseMove();
	virtual void  OnLeftButtonDown(); 
	virtual void  OnLeftButtonUp();
	virtual void  OnMiddleButtonDown(); 
	virtual void  OnMiddleButtonUp();
	virtual void  OnRightButtonDown();
	virtual void  OnRightButtonUp();

	virtual	void  OnLeftDClick();
	virtual	void  OnRightDClick();
	virtual	void  OnMiddleDClick();
	

	virtual	void  OnMouseWheelForward();
	virtual	void  OnMouseWheelBackward();

	virtual	void  TransformCoordinate(double &X, double &Y, double &Z);
	
	void  AddInteractorStyleMaracas(InteractorStyleMaracas* interactorStyleMaracas);
	void  RemoveInteractorStyleMaracas(InteractorStyleMaracas* interactorStyleMaracas);
	void  InsertInteractorStyleMaracas(int pos, InteractorStyleMaracas* interactorStyleMaracas);
	void  CallLstInteractorStyleMaracas(int type);
//JCP 13/05/2009
	//wxVtk2DBaseView		*GetWxVtk2DBaseView();
	//wxVtk3DBaseView		*GetWxVtk3DBaseView();
	wxVtkBaseView	*GetWxVtk2DBaseView();
	wxVtkBaseView	*GetWxVtk3DBaseView();
//JCP 13/05/2009
			void		SetwxVtkBaseView(wxVtkBaseView *wxvtkbaseview);
			void		SetActiveAllInteractors(bool ok);

			void		SetRefresh_waiting();
			void		SetParent_refresh_waiting();
			void		AddParentToReport(wxEvtHandler* parentToReport);

			bool		GetRefresh_waiting();
			bool		GetParent_refresh_waiting();
			wxEvtHandler* GetParentToReport(int i);

			void		EvaluateToRefresh();
			void		BlockRefresh();
			void		UnBlockRefresh();

protected:
		std::vector< InteractorStyleMaracas* >	_lstInteractorStyleMaracas;

private:
	bool						_blockRefresh;
	bool						_refresh_waiting;
	bool						_parent_refresh_waiting;
	wxVtkBaseView				*_wxvtkbaseview;
	std::vector<wxEvtHandler*>	_lstParentToReport;
};

#endif /*VTKINTERACTORSTYLEBASEVIEW_H_*/
