/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasMultipleVolumeRendererView.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.7 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __wxMaracasMultipleVolumeRendererViewPanelH__
#define __wxMaracasMultipleVolumeRendererViewPanelH__

#include <vector>
#include <wx/wx.h>
#include "wx/aui/aui.h"
#include <iostream>
#include "marTypes.h"
#include "vtkProp3D.h"

#include "wxMaracasMultipleVolumeRendererManager.h"
#include "wxMaracasMultipleVolumeRendererPanel.h"



class  creaMaracasVisu_EXPORT  wxMaracasMultipleVolumeRendererView : public wxPanel
{

public:
	wxMaracasMultipleVolumeRendererView( wxWindow* parent, std::string path);
    ~wxMaracasMultipleVolumeRendererView( );

	static wxMaracasMultipleVolumeRendererView* getInstance(wxWindow* parent,std::string path="");

	static wxMaracasMultipleVolumeRendererView* getInstance();

	void setRenderer(vtkRenderer*  renderer);
	
	void addVolume(vtkImageData* img, std::string dataname="");		

	void loadVolume(wxString filename, wxString dataname);

	void onLoadImageFile();

	void addVolumeRendererPanel(wxMaracasMultipleVolumeRendererPanel* irmview, std::string dataname="");

	std::string getPath();

	void deleteVolume(int volid);

	void addRemoveActor(int id, bool remove);	

	void SetValuesColorPointsFunction(int volid, std::vector<double> greylevelcolors,std::vector<double> red,std::vector<double> green,std::vector<double> blue);
	void SetValuesPointsFunction(int volid, std::vector<double> greylevel, std::vector<double> values);

	void addVolumeViewPanel(wxMaracasMultipleVolumeRendererPanel* irmview, std::string dataname);

	vtkPiecewiseFunction* GetTransferFunction(int volumeid);
	vtkColorTransferFunction* GetColorFunction(int volumeid);

	std::vector<vtkImageData*> GetOutputImages();

	void changeCompositeMIPFunction(int id, int function);

	wxMaracasMultipleVolumeRendererManager* getVolumeRenderManager();

private:
	static wxMaracasMultipleVolumeRendererView* instance;

	wxMaracasMultipleVolumeRendererManager* volmanager;
	wxAuiManager* wxauimanager;
	wxToolBar* _toolb;
	
	std::string _path;
    std::vector<vtkImageData*> imgVect;
};

class ToolBarEventHandlerMultipleVolumeRenderer : public wxEvtHandler{

	public:
		ToolBarEventHandlerMultipleVolumeRenderer();
		~ToolBarEventHandlerMultipleVolumeRenderer();

		void onLoadImageFile(wxCommandEvent& event);

	private:

		DECLARE_EVENT_TABLE()
	};

class ToolBarMultipleVolumeRenderer : public wxToolBar{

	
public:
	ToolBarMultipleVolumeRenderer(wxWindow * parent,std::string iconsdir);
	~ToolBarMultipleVolumeRenderer(void);


private:

	ToolBarEventHandlerMultipleVolumeRenderer* _evthand;

};

#endif

