/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wxMaracasRenderImageTransformation_H_
#define wxMaracasRenderImageTransformation_H_

#include <vtkTransform.h>

#include "volumerenderermanager.h"
#include "wxMaracasSurfaceRenderingManager.h"
#include "creaMaracasVisu_EXPORT.h"

class creaMaracasVisu_EXPORT wxMaracasRenderImageTransformation
{
public:

        wxMaracasRenderImageTransformation(VolumeRendererManager* vol, wxMaracasSurfaceRenderingManager* surface1,
		wxMaracasSurfaceRenderingManager* surface2, wxMaracasSurfaceRenderingManager* surface3, int id);
	~wxMaracasRenderImageTransformation();

	void Translate(int tx, int ty, int tz, int rx, int ry, int rz, int sx, int sy, int sz);
// EED 2022-08-04	
//	void Refresh()throw(char*);
	void Refresh();

private:
        VolumeRendererManager* vol;
	wxMaracasSurfaceRenderingManager* surface1;
	wxMaracasSurfaceRenderingManager* surface2;
	wxMaracasSurfaceRenderingManager* surface3;
	
	vtkTransform* transformV;
	vtkTransform* transformS1;
	vtkTransform* transformS2;
	vtkTransform* transformS3;

	int propID;
};

#endif
