/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSurfaceRenderingManager.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:17:03 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/




#ifndef __wxMaracasSurfaceRenderingManagerH__
#define __wxMaracasSurfaceRenderingManagerH__

#include <iostream>
#include <vector>


//EED 2022-07-21
//#include <vtkMatrix4x4.h>

#include "wxMaracasSurfaceRenderingManagerData.h"



class wxMaracasSurfaceRenderingManager  {

public:
	wxMaracasSurfaceRenderingManager();
	~wxMaracasSurfaceRenderingManager();

	/**
	**	Sets the renderer to manage the prop3D from the surface render
	**/
	void setRenderer(vtkRenderer*  renderer);

	/**
	**	Gets the renderer which manages the prop3D from the surface render
	**/
	vtkRenderer* getRenderer();
	
	/**
	** Updates surface
	**/
//	void Update(int pid)throw(char*);
//	void Update(int pid)throw(int);
	void Update(int pid);
	
	/**
	**	Adds a prop3D to the manager and returns the identifier
	**/
// EED 2022-08-04	
//	int addProp3D(int idTP, vtkProp3D* prop3D, std::string dataname) throw (char*);
	int addProp3D(int idTP, vtkProp3D* prop3D, std::string dataname);

        /**
        **	Adds a polydata and creates the prop3D (actor) to the manager and returns the identifier
        **/
        int addProp3D(int idTP, std::string filename, std::string dataname = "");

	/**
	**	Adds a prop3D to the manager and returns the identifier
	**/
// EED 2022-08-04	
//	int addPropMHD(int idTP, vtkImageData* imagedata, std::string dataname) throw(char*);
	int addPropMHD(int idTP, vtkImageData* imagedata, std::string dataname) ;
	/**
	**	Changes the opacity in a prop3D
	**/
// EED 2022-08-04	
//	void changeOpacity(int propid, int value)throw(char*);
	void changeOpacity(int propid, int value);

	/**
	**	changes the isovalue in a prop3D
	**/
        void changeIsoValue(int propid, double value);

        void changeIsoValue(int propid, double min, double max );

	/**
	**	loads a prop3D from a nSTL file
	**/
        //vtkProp3D* getProp3D(std::string filename);

	/**
	**	loads a MHD file to convert it into an actor
	**/
	vtkImageData* getImageData(std::string filename);

	/**
	** Gets image data asotiated with the rendering manager
	**/
	vtkImageData* getImageData();

        virtual void setImageData(vtkImageData* img);

	/**
	**	adds or removes an actor depending of the bool value
	**/
// EED 2022-08-04	
//        bool addRemoveActor(int propid, bool addremove)throw(char*);
        bool addRemoveActor(int propid, bool addremove);
	/**
	**
	**/
// EED 2022-08-04	
//	void addRemoveSurfaceBox(int propid, bool addremove)  throw(char*);
	void addRemoveSurfaceBox(int propid, bool addremove);
	/**
	**	Check if the variables are setted correctly
	**/

// EED 2022-08-04	
//	void checkInvariant()throw(char*);
	void checkInvariant();

	/**
	**	Given an id search the data in the vector
	**/
// EED 2022-08-04	
//	wxMaracasSurfaceRenderingManagerData* getViewData(int id)throw(char*);
	wxMaracasSurfaceRenderingManagerData* getViewData(int id);

	/**
	**
	**/
	void setInteractor(vtkRenderWindowInteractor*  interactor);

	/**
	**	Given the id, return the max iso value from the imagedata
	**/
// EED 2022-08-04	
//	int getMaxIsoValue(int propid)throw(char*);
	int getMaxIsoValue(int propid);


	/**
	**	Changes the color of the actor
	**/
// EED 2022-08-04	
//	void changeColor(int propid, double red, double green, double blue) throw(char*);
	void changeColor(int propid, double red, double green, double blue);

// EED 2022-08-04	
//	void deleteActor(int propid)throw (char *);
	void deleteActor(int propid);

	void Transform(vtkMatrix4x4* tmatrix);

	bool interactorSet();


        void enableBoundingBox(int propid, bool enable);

        void saveProp3DSTL(int propid,const char* filename);

        void loadProp3DSTL(const char* filename);


        void exportImageStencil(int propid,const char* filename);
	
private:	
	std::vector<wxMaracasSurfaceRenderingManagerData*> prop3Dvect;

	vtkRenderer*  _renderer;
	vtkRenderWindowInteractor*  _interactor;
	vtkImageData* image;

	int _idCount;

	

	
};

#endif 
