/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXMARACASSURFACERENDERINGMANAGERDATA_H_
#define WXMARACASSURFACERENDERINGMANAGERDATA_H_

#include <vtkProp3D.h>
#include "vtkRenderer.h"
#include "vtkSTLReader.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkProperty.h"
#include "vtkBoxWidget.h"


#define PLY  ".ply"
#define STL  ".stl"
#define VTK  ".vtk"

using namespace std;

class wxMaracasSurfaceRenderingManagerData {

public:
	wxMaracasSurfaceRenderingManagerData(vtkProp3D* _prop3Dvect, std::string dataname="", vtkRenderWindowInteractor*  interactor=NULL);	
        wxMaracasSurfaceRenderingManagerData(string filename, vtkRenderWindowInteractor*  interactor);
	~wxMaracasSurfaceRenderingManagerData();	
	
	/**
	**	Adds a prop3D to the world of the application
	**/
	void setProp3D(vtkProp3D* prop3D);
	/**
	**	Changes the opacity in a prop3D
	**/
	void changeOpacity(int value);		
	/**
	**	Check if the variables are setted correctly
	**/
	void checkInvariant();
	/**
	**	get the prop3D 
	**/
	vtkProp3D* getProp3D();
	/**
	**	return the id from the daat
	**/
	int getId();
	/**
	**	set data id
	**/
	void setId(int propid);
	/**
	**	Get the filanme
	**/
    std::string getDataname();
	/**
	** Set the filanme
	**/
    void setDataname(std::string dataname);
	
	/**
	**	creates the image 
	**/
	void contourExtractor(int isovalue);

	/**
	**	Changes the color of the actor
	**/
	void changeColor(double red, double green, double blue);	
	
	/**
	** adds or removes the surface box
	**/
	void addRemoveSurfaceBox(bool visible);

	void initializeBoxWidget(vtkRenderWindowInteractor*  interactor);

        void saveProp3DSTL(const char* filename);

        virtual void enableBoxWidget(bool enable);

        void exportImageStencil(const char* filename);

        vtkProp3D* getProp3D(std::string filename);
protected:
        vtkPolyDataMapper* _dataMapper;
	/**
	 * Prop 3D (data actor)
	 */
	vtkProp3D* _prop3D;	
	/**
	 *  Dataname given by the user (ex. filename) 
	 **/
	std::string _dataname;	
	
	/**
	**
	**/
	vtkBoxWidget* _boxWidgetS1;
private:
	
	/*
	 * id of the data
	 */
	int _id;		

	

	
};

#endif /*WXMARACASSURFACERENDERINGMANAGERDATA_H_*/
