/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXSPHEREVIEW_H_
#define WXSPHEREVIEW_H_

#include "wxMPRBaseData.h"
#include "wxVtk2DBaseView.h"
#include "idAlBeRa.h"
#include "vtkInteractorStyleSphere.h"
#include "vtkTransform.h"

class wxMPRBaseData;

class wxSphereView : public wxVtk2DBaseView
{
public:
	wxSphereView( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata /*, vtkImageData *imageData*/);
	~wxSphereView();
	virtual void Configure();
			void SetImage();

	void RotationEnd();
	void RotationStart(double vx, double vy, bool ok_v, bool ok_ang);
	virtual void	RefreshView();
	virtual void 	Refresh();

	virtual void	SetVoxel(double i, double j, int delta, double id, double gris);
			void	SetDeltaVoxel(int delta);
			double	GetRadio();
			void	SetRadio(double radio);
			int		GetIdOfImage(double radio);
			void	SetXYZtoParent(double i, double j);
			void	RefreshPoint();

private:	
	std::vector<idAlBeRa*> 		_lstId;
	int							_centerX;
	int							_centerY;
	int							_centerZ;
	double						_radio;
	double						_ang;
	double						_vxb;
	double						_vyb;
	int							_delta;
	vtkImageData				*_imageDataOriginal;
	vtkImageData				*_imageSphere;
	vtkMPRBaseData				*_vtkmprbasedata;
	vtkInteractorStyleSphere	*_vtkinteractorstylesphere;
	vtkTransform				*_transform; 
	vtkTransform				*_transform1; 
	vtkTransform				*_transform2; 

	void	FiltreImage(int id, double radio);
	void	FiltreImageB(int id, double radio, bool ok,int deltaTMP);
	void	DefineImageSphere();
	void	ResetlstId();
	void	InitSphere(double points[4][3]);
	double	SphereFindCenter(double P[4][3], double cc[3]);
	double	determinant(double a[4][4], int n);
	void	GetPointSphere(double p[3],double r1,double angA,double angB);
	void	RotatePointOverTheSphere( double pp[3], double p[3],double cc[3]);
//	void	TransferePoints(double pp1[3],double pp2[3],double AngX,double AngY,vtkImageData *image);
};

#endif /*WXSPHEREVIEW_H_*/
