/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTK2DBASEVIEW_H_
#define WXVTK2DBASEVIEW_H_

#include "wxVtkBaseView.h"
#include "vtkImageViewer2_XYZ.h"

//class vtkInteractorStyleBaseView;
#include "vtkInteractorStyleBaseView.h"
#include "vtkInteractorStyleBaseView2D.h"
class vtkInfoTextImage;
class vtkInfoTextImageInteractor;

//------------------------------------------------------------------

class creaMaracasVisu_EXPORT wxVtk2DBaseView: public wxVtkBaseView{
public:
	wxVtk2DBaseView(wxWindow *parent,bool TDxWindow=false);
	virtual 					~wxVtk2DBaseView();
	virtual void				Configure(bool okimage=true);
	vtkImageViewer2_XYZ*		_imageViewer2XYZ;

	virtual void				Refresh();
	virtual void				ResetView();
	virtual int					GetActualSlice();
	virtual void				SetActualSlice(int slice);
	void						SetInteractorStyleImage(vtkInteractorStyleBaseView *interactorstylebaseview);

	virtual vtkRenderer*		GetRenderer();
	virtual vtkRenderWindow* 	GetRenWin();
	virtual void				TransformCoordinate_spacing_ViewToModel(double &X,double &Y, double &Z);
	virtual void				TransformCoordinate_spacing_ModelToView(double &X,double &Y, double &Z);
	virtual void				GetSpacing(double spc[3]);

	void setColorTransferFunction(vtkColorTransferFunction* colortable);
	void SetColorWindow(double level);
	void SetColorLevel(double level);
	void SetInterpolate(bool iterpolate);
	
    virtual int GetDirection();
    virtual void GetNormal(double normal[3] );
    
	void SetImageToVtkViewer(vtkImageData *imageData);
	
	//EED 01nov2012
	void UpdateColorWindowLevel();

	//EED 05juin2019
	void UpdateCameraParallelScale();
	void SetOpacityText(double opacity);

private:
	vtkInfoTextImage				*_vtkIinfoTextImage;
	vtkInfoTextImageInteractor		*_vtkIinfoTextImageInteractor;
	vtkInteractorStyleBaseView2D 	*_style2D;

protected:

};

#endif /*WXVTK2DBASEVIEW_H_*/
