/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTKMPR2DVIEW_H_
#define WXVTKMPR2DVIEW_H_

#include "vtkInteractorStyleMPRView.h"

#include "wxMPRBaseData.h"
#include "wxVtk2DBaseView.h"

#include "vtkPolyDataMapper.h"
#include <vtkPolyData.h>
#include <vtkPoints.h>
#include "vtkActor.h"
#include "vtkPolyData.h"

class creaMaracasVisu_EXPORT wxVtkMPR2DView :  public wxVtk2DBaseView
{
public:
	wxVtkMPR2DView( wxWindow *parent, int direction ,bool TDxWindow=false );
	~wxVtkMPR2DView();
	void Configure();
	virtual	void			Refresh();
			vtkMPRBaseData	*GetVtkmprbasedata();
	virtual int				GetActualSlice();
	virtual	void			SetActualSlice(int slice);
			bool			IfMouseTouchX(double x, double y, double z);
			bool			IfMouseTouchY(double x, double y, double z);
			bool			IfMouseTouchZ(double x, double y, double z);
			void			MoveX(double x, double y, double z);
			void			MoveY(double x, double y, double z);
			void			MoveZ(double x, double y, double z);
			void			ChangeAxisColor(double x, double y, double z);
	virtual void			TransFromCoordScreenToWorld(double &X, double &Y, double &Z, bool keepNormalDirection=false, int type=2);
			void			SetVisibleAxis(bool ok);
    virtual int             GetDirection();
			void 			ResetBackXYZ();

private:
	int							_backX;
	int							_backY;
	int							_backZ;
	bool 						_backFixAxis2D;
	double 						_backOpacityAxis;
	bool						_visibleAxis;
	int							_direction;
	vtkPoints					*_ptsA;
	vtkActor					*_lineAActor;
	vtkPolyDataMapper			*_lineAMapper;
    vtkPolyData					*_pdA;
	vtkPoints					*_ptsB;
	vtkActor					*_lineBActor;
	vtkPolyDataMapper			*_lineBMapper;
    vtkPolyData					*_pdB;
//	vtkInteractorStyle2DMaracas	*_interactorStyle2DMaracas;
	vtkInteractorStyleMPRView	*_interactorstylemprview;
};

#endif /*WXVTKMPR2DVIEW_H_*/
