/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXWIDGETMESURE2D_H_
#define WXWIDGETMESURE2D_H_

#include <wx/splitter.h>
#include <wx/checkbox.h>
#include "manualContourControler.h"
#include "manualContourModel.h"
#include "manualViewContour.h"

#include "wxVtk2DBaseView.h"

class wxWidgetMesure2D : public wxSplitterWindow
{
public: 
	wxWidgetMesure2D( wxWindow *parent );
	~wxWidgetMesure2D();

	void OnActiveMessureTool(wxCommandEvent& event);
	void OnVisibleMessureTool(wxCommandEvent& event);
	void OnCloseContour(wxCommandEvent& event);
	void OnVisibleInformation(wxCommandEvent& event);

	manualContourModel*	GetManualContourModel();
	virtual void ConfigureA(wxVtk2DBaseView *wxvtk2Dbaseview);

protected:
	wxVtk2DBaseView			*_wxvtk2Dbaseview;
	virtual wxWindow		*CreateWin1a(wxWindow *parent);
private:
	wxCheckBox				*_cb_messuretool; 
	wxCheckBox				*_cb_mt_visible; 
	wxCheckBox				*_cb_closeContour; 
	wxCheckBox				*_cb_visibleText; 

	manualContourControler	*_manContourControl_1;
	manualContourModel		*_mContourModel_1;
	manualViewContour		*_mViewContour_1;

	void	ActiveMessureTool(bool ok);

//	DECLARE_EVENT_TABLE();
};


#endif /*WXWIDGETMESURE2D_H_*/
