/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sante)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef _CREAVTKPLANEWIDGET_H_
#define _CREAVTKPLANEWIDGET_H_

//---------------------------------------------
// Class Name: PlaneWidget
// [classdescription]
//---------------------------------------------

#include "vtkCommand.h"
#include "vtkImageData.h"
#include "vtkPlaneSource.h"
#include "vtkPlaneWidget.h"
#include "vtkRenderer.h"


class creaVtkPlaneWidget;

//---------------------------------------------
class creaVtkCallbackPlaneWidget : public vtkCommand
{
	public:
		creaVtkPlaneWidget *creavtkplanewidget;
			
		static creaVtkCallbackPlaneWidget *New() { return new creaVtkCallbackPlaneWidget; }
		void Delete() { delete this; }
		virtual void Execute(vtkObject *caller, unsigned long, void*);
		creaVtkCallbackPlaneWidget():creavtkplanewidget(NULL) { }			
};


//---------------------------------------------
//---------------------------------------------
//---------------------------------------------

class creaVtkPlaneWidget
{

//---------------------------------------------
//Methods and attributes exposed to other classes
//---------------------------------------------
public :
    creaVtkPlaneWidget();
    ~creaVtkPlaneWidget();

    void 		        SetImage(vtkImageData* image);
    vtkImageData*       GetImage();
    void 		        SetActive(bool active);
    bool 		        GetActive();
    void 		        SetRenderer(vtkRenderer* renderer);
    vtkRenderer* 	    GetRenderer();
    vtkPlaneSource*     GetPlaneSource();
    void 		        SetResolution(int resolution);
    int 		        GetResolution();
    void 		        SetRepresentation(int represtation);
    int 		        GetRepresentation();
    std::vector<double> GetCenter();
    std::vector<double> GetNormal();

    void                SetOrigin( std::vector<double> origin);
    void                SetNormalIn( std::vector<double> normalin);

    void 		        Process();
    void 		        UpdatePlane();
    virtual void 	    Execute();


//---------------------------------------------
//Methods and attributes exposed only to classes
//that are derived from this class
//---------------------------------------------
protected:

//---------------------------------------------
//Methods and attributes only visible by this class
//---------------------------------------------
private:
	bool				_firsttime;
 	bool 				_active;
	vtkImageData*		_image;
	vtkRenderer	*		_renderer;
	int 				_resolution;
	int 				_representation;
    std::vector<double> _origin;
	std::vector<double> _normalin;

	vtkPlaneWidget      *_vPlaneWidget;
    vtkPlaneSource      *_vPlaneSource;
};

//-end of _CREAVTKPLANEWIDGET_H_------------------------------------------------------
#endif
