/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sante)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef _VTKTENSORSVISU_H_
#define _VTKTENSORSVISU_H_


#include "vtkCubeSource.h"
#include "vtkPolyData.h"
#include "vtkPolyDataNormals.h"
#include "vtkPointData.h"
#include "vtkSphereSource.h"
#include "vtkTensorGlyph.h"
#include "vtkSuperquadricSource.h"

#include "vtkVectorsTensorsVisuBase.h"


//---------------------------------------------
// Class Name: vtkTensorsVisu
// [classdescription]
//---------------------------------------------

class vtkTensorsVisu: public vtkVectorsTensorsVisuBase
{

//---------------------------------------------
//Methods and attributes exposed to other classes
//---------------------------------------------
public :
  vtkTensorsVisu();
  ~vtkTensorsVisu();

  void Process();


//---------------------------------------------
//Methods and attributes exposed only to classes
//that are derived from this class
//---------------------------------------------
protected:

//---------------------------------------------
//Methods and attributes only visible by this class
//---------------------------------------------
private:

   vtkSmartPointer<vtkSphereSource> 		ss;
   vtkSmartPointer<vtkSuperquadricSource> 	superquadratic;
   vtkSmartPointer<vtkCubeSource> 			cs; 
   vtkSmartPointer<vtkTensorGlyph> 			tg;
   vtkSmartPointer<vtkPolyDataNormals> 		pdn;
   vtkSmartPointer<vtkPolyData> 			pd;
   vtkSmartPointer<vtkPointData> 			pod;
};

//-end of _VTKTENSORSVISU_H_------------------------------------------------------
#endif
