 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


# ==================================
#           W A R N I N G !
# ==================================
#
# This file is dupplicated as BBTKConfigurePackage2.cmake
#
# Only ONE commented out line, in BBTKConfigurePackage2.cmake differs
# :-(
# In case of modification, mind to modify BBTKConfigurePackage2.cmake as well!
#


MESSAGE(STATUS "")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "CONFIGURING BBTK PACKAGE ${BBTK_PACKAGE_NAME}")

#---------------------------------------------------------------------------
SET(${BBTK_PACKAGE_NAME}_SOURCE_DIR ${CMAKE_CURRENT_SOURCE_DIR})
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
IF(NOT BBTK_CORE_PACKAGE)
  #---------------------------------------------------------------------------
  SET(BBTK_PACKAGE_LIBS 
    ${BBTK_PACKAGE_LIBS}
    ${BBTK_LIBRARIES})
  MARK_AS_ADVANCED(BBTK_DIR)
  #-------------------------------------------------------------------------
  # If not a core package must include necessary cmake scripts
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKConfigurePackagePaths.cmake)
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKBuildAllOption.cmake)
  #  INCLUDE(${BBTK_CMAKE_DIR}/BBTKMacros.cmake)
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKFindLibraries.cmake)
  #-------------------------------------------------------------------------
  # Configure bbtk_config_build.xml.in for bbi to find the bbs
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKConfigureBbtkConfigXmlForBuildTree.cmake)
  #------------------------------------------------------------------------- 
  # WARNING : 
  # FOR THE MOMENT ONLY ONE BBTK PACKAGE PER PROJECT ALLOWED!!!
  # 
  SET(${BBTK_PACKAGE_NAME}_BINARY_DIR  ${PROJECT_BINARY_DIR})
  # ${CMAKE_CURRENT_BINARY_DIR})
  #------------------------------------------------------------------------- 
  #---------------------------------------------------------------------------
  # CREATES THE bbtkPackage TEXT FILE
  CONFIGURE_FILE(
    ${BBTK_CMAKE_DIR}/bbtkPackage.in
    ${${BBTK_PACKAGE_NAME}_BINARY_DIR}/bbtkPackage
    @ONLY
    )
  IF (WIN32)
    CONFIGURE_FILE(
		${BBTK_CMAKE_DIR}/PlugPackage.bat.in
		${${BBTK_PACKAGE_NAME}_BINARY_DIR}/PlugPackage.bat
		COPYONLY
    )
	INSTALL ( FILES ${${BBTK_PACKAGE_NAME}_BINARY_DIR}/bbtkPackage      DESTINATION  "." )
    INSTALL ( FILES ${${BBTK_PACKAGE_NAME}_BINARY_DIR}/PlugPackage.bat  DESTINATION  "." )
  ELSE(WIN32)
    CONFIGURE_FILE(
		${BBTK_CMAKE_DIR}/PlugPackage.sh.in
		${${BBTK_PACKAGE_NAME}_BINARY_DIR}/PlugPackage.sh
		COPYONLY
    )
	INSTALL ( FILES ${${BBTK_PACKAGE_NAME}_BINARY_DIR}/bbtkPackage     DESTINATION  "share/bbtk" )
    INSTALL ( FILES ${${BBTK_PACKAGE_NAME}_BINARY_DIR}/PlugPackage.sh  DESTINATION  "share/bbtk" )
  ENDIF (WIN32)

  #---------------------------------------------------------------------------
ELSE(NOT BBTK_CORE_PACKAGE)
  SET(${BBTK_PACKAGE_NAME}_BINARY_DIR ${PROJECT_BINARY_DIR})
ENDIF(NOT BBTK_CORE_PACKAGE)
#---------------------------------------------------------------------------





#----------------------------------------------------------------------------
# USER DEFINED ADDITIONAL INCLUDE DIRS
INCLUDE_DIRECTORIES(${${BBTK_PACKAGE_NAME}_INCLUDE_DIRS})
#----------------------------------------------------------------------------


#---------------------------------------------------------------------------
# Package dependencies
SET(${BBTK_PACKAGE_NAME}_DEPS bb${BBTK_PACKAGE_NAME})
STRING(REGEX MATCH "${${BBTK_PACKAGE_NAME}_DEPS}" 
  ${BBTK_PACKAGE_NAME}_IN_DEPS
  "${BBTK_PACKAGES_DEPS}")
#---------------------------------------------------------------------------
#SET(BBTK_PACKAGES_DEPS "" CACHE INTERNAL "bbtk packages dependencies" FORCE)



#----------------------------------------------------------------------------
# VARS CONFIGURED IN bbPackage.h AND IN doc/bbdoc/header.html.in
SET(BBTK_PACKAGE_AUTHOR        "${${BBTK_PACKAGE_NAME}_AUTHOR}")
SET(BBTK_PACKAGE_DESCRIPTION   "${${BBTK_PACKAGE_NAME}_DESCRIPTION}")
SET(BBTK_PACKAGE_MAJOR_VERSION ${${BBTK_PACKAGE_NAME}_MAJOR_VERSION})
SET(BBTK_PACKAGE_MINOR_VERSION ${${BBTK_PACKAGE_NAME}_MINOR_VERSION})
SET(BBTK_PACKAGE_BUILD_VERSION ${${BBTK_PACKAGE_NAME}_BUILD_VERSION})
SET(BBTK_PACKAGE_VERSION 
  "\"${${BBTK_PACKAGE_NAME}_MAJOR_VERSION}.${${BBTK_PACKAGE_NAME}_MINOR_VERSION}.${${BBTK_PACKAGE_NAME}_BUILD_VERSION}\"")
#----------------------------------------------------------------------------


#---------------------------------------------------------------------------
# If package deps not in global deps : add them
IF(NOT ${BBTK_PACKAGE_NAME}_IN_DEPS)
  SET(BBTK_PACKAGES_DEPS "${${BBTK_PACKAGE_NAME}_DEPS};${BBTK_PACKAGES_DEPS}"
    CACHE INTERNAL "bbtk packages dependencies" FORCE)
  #   MESSAGE(STATUS "Packages=${BBTK_PACKAGES_DEPS}")
ENDIF(NOT ${BBTK_PACKAGE_NAME}_IN_DEPS)
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Package dependencies

IF(${BBTK_PACKAGE_NAME}_USE_OPENMP)
  SET(USE_OPENMP ON CACHE BOOL "Use OPENMP" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${OpenMP_libomp_LIBRARY_crea}
    )
   LINK_DIRECTORIES( /opt/local/lib/libomp )
ENDIF(${BBTK_PACKAGE_NAME}_USE_VTK)

IF(${BBTK_PACKAGE_NAME}_USE_VTK)
  SET(USE_VTK ON CACHE BOOL "Use VTK" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${VTK_LIBRARIES}
    )
ENDIF(${BBTK_PACKAGE_NAME}_USE_VTK)

IF(${BBTK_PACKAGE_NAME}_USE_ITK)
  SET(USE_ITK ON CACHE BOOL "Use ITK" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${ITK_LIBRARIES}
    )

	#Need to add additional gdcm  libraries provided by system
	IF(WIN32)
		IF(USE_GDCM2)
			SET(${BBTK_PACKAGE_NAME}_LIBS
				${${BBTK_PACKAGE_NAME}_LIBS}
				 vtkgdcm gdcmIOD gdcmMSFF gdcmexpat gdcmCommon gdcmMEXD gdcmDSED gdcmDICT 
					gdcmjpeg8 gdcmjpeg12 gdcmjpeg16 socketxx gdcmopenjpeg gdcmcharls 
				)
		ENDIF()
	ENDIF(WIN32)
ENDIF(${BBTK_PACKAGE_NAME}_USE_ITK)

IF(${BBTK_PACKAGE_NAME}_USE_QT)
  SET(USE_QT4 ON CACHE BOOL "Use QT" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${QT_LIBRARIES}
    )
ENDIF(${BBTK_PACKAGE_NAME}_USE_QT)

#----------

IF(${BBTK_PACKAGE_NAME}_USE_GDCM)
  SET(USE_GDCM ON CACHE BOOL "Use GDCM" )
  SET(USE_GDCM2 OFF CACHE BOOL "Use GDCM2" )
  SET(USE_GDCM_VTK ON CACHE BOOL "Use GDCM_VTK" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${GDCM_LIBRARIES}
    )

	IF(USE_GDCM)
		IF(USE_GDCM2)
		message(FATAL_ERROR "You cannot select both GDCM and GDCM2 (DICOM library readers)")
		ENDIF(USE_GDCM2)
	ENDIF(USE_GDCM)
ENDIF(${BBTK_PACKAGE_NAME}_USE_GDCM)

#----------

IF(${BBTK_PACKAGE_NAME}_USE_GDCM2)
  SET(USE_GDCM2 ON CACHE BOOL "Use GDCM2" FORCE)
  SET(USE_GDCM2_VTK ON CACHE BOOL "Use GDCM2_VTK" FORCE)
  #For some reasons GDCM_LIBRARY is not defined for gdcm2 in windows
  IF(WIN32)
	SET(${BBTK_PACKAGE_NAME}_LIBS
		${${BBTK_PACKAGE_NAME}_LIBS}
		vtkgdcm gdcmIOD gdcmMSFF gdcmexpat gdcmCommon gdcmMEXD gdcmDSED gdcmDICT 
		gdcmjpeg8 gdcmjpeg12 gdcmjpeg16 socketxx gdcmopenjpeg gdcmcharls 
		)
  ELSE(WIN32)
	SET(${BBTK_PACKAGE_NAME}_LIBS
		${${BBTK_PACKAGE_NAME}_LIBS}
		${GDCM_LIBRARY}
		)
	ENDIF(WIN32)
		
	IF(USE_GDCM2)
		IF(USE_GDCM)
		message(FATAL_ERROR "You cannot select both GDCM and GDCM2 (DICOM library readers)")
		ENDIF(USE_GDCM)
	ENDIF(USE_GDCM2)
ENDIF(${BBTK_PACKAGE_NAME}_USE_GDCM2)

#----------

IF(${BBTK_PACKAGE_NAME}_USE_GSMIS)
  SET(USE_GSMIS ON CACHE BOOL "Use GSMIS" FORCE)
  SET(${BBTK_PACKAGE_NAME}_LIBS
    ${${BBTK_PACKAGE_NAME}_LIBS}
    ${GSMIS_LIBRARIES}
    )
ENDIF(${BBTK_PACKAGE_NAME}_USE_GSMIS)

IF(${BBTK_PACKAGE_NAME}_USE_WXWIDGETS)
  IF(BBTK_CORE_PACKAGE)
    SET(BBTK_USE_WXWIDGETS ON CACHE BOOL "Use wxWidgets" FORCE)
    MESSAGE(STATUS "BBTK_USE_WXWIDGETS forced to ON by the compilation of the package ${BBTK_PACKAGE_NAME}")
    # bbtk already links against wx ...
    IF(WIN32)
      SET(${BBTK_PACKAGE_NAME}_LIBS
        ${${BBTK_PACKAGE_NAME}_LIBS}
        ${WXWIDGETS_LIBRARIES}
        )
    ENDIF(WIN32)
  ELSE(BBTK_CORE_PACKAGE)
    # If linking against a non-wx bbtk : problem
    IF(NOT BBTK_BUILT_WITH_WX)
      MESSAGE(FATAL_ERROR "The bbtk package ${BBTK_PACKAGE_NAME} needs wxWidgets however the bbtk library which was found on your system was not compiled with wxWidgets : recompile it and rebuild the package.")
    ELSE(NOT BBTK_BUILT_WITH_WX)
      SET(USE_WXWIDGETS ON CACHE BOOL "Use wxWidgets" FORCE)
      # bbtk already links against wx ...
      IF(WIN32)
        SET(${BBTK_PACKAGE_NAME}_LIBS
          ${${BBTK_PACKAGE_NAME}_LIBS}
          ${WXWIDGETS_LIBRARIES}
          )
      ENDIF(WIN32)
    ENDIF(NOT BBTK_BUILT_WITH_WX)
  ENDIF(BBTK_CORE_PACKAGE)
ENDIF(${BBTK_PACKAGE_NAME}_USE_WXWIDGETS)


#---------------------------------------------------------------------------

MESSAGE(STATUS "")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "${BBTK_PACKAGE_NAME} link libraries:")
MESSAGE(STATUS "${${BBTK_PACKAGE_NAME}_LIBS}")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "")

#---------------------------------------------------------------------------
# Recurse into ADD_SUBDIRECTORY
ADD_SUBDIRECTORY(src)
ADD_SUBDIRECTORY(doc)
ADD_SUBDIRECTORY(bbs)
ADD_SUBDIRECTORY(data)
#---------------------------------------------------------------------------

MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "")

#-----------------------------------------------------------------------------
# EOF
#-----------------------------------------------------------------------------




