 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#-----------------------------------------------------------------------------
MESSAGE ( STATUS "")
MESSAGE ( STATUS "=======================================")
MESSAGE ( STATUS "     LOOKING FOR LIBRARIES NEEDED")
MESSAGE ( STATUS "=======================================")
MESSAGE ( STATUS "")
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# 11/12/08 : BBTK IS NOW BASED ON crea
SET(CREA_VERBOSE_CMAKE TRUE)
FIND_PACKAGE(crea REQUIRED )
set(crea_BUILD_SETTINGS_FILE OFF)
IF (crea_FOUND)
  INCLUDE(${crea_USE_FILE} )
ENDIF(crea_FOUND)
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# USE SHIPPED BOOST ?
IF(BBTK_KERNEL OR BBTK_CORE_PACKAGE)

#IF(BBTK_USE_SHIPPED_BOOST)

#  MESSAGE ( STATUS "=======================================")
#  MESSAGE ( STATUS "bbtk uses shipped boost C++ library (${BBTK_SHIPPED_BOOST})")
#  INCLUDE_DIRECTORIES( 
#    ${PROJECT_SOURCE_DIR}/kernel/src/ThirdParty/${BBTK_SHIPPED_BOOST})

  # TO DO : CLEANLY BLOCK auto_link.hpp INCLUSION 
  #CREA_DEFINE(BOOST_SIGNALS_NO_LIB)
#  SET(BBTK_BOOST_LIBRARIES
#    bbtk_boost_signals
#    )  
  
#ELSE(BBTK_USE_SHIPPED_BOOST)
  SET(USE_BOOST ON CACHE BOOL "Use boost C++ library" FORCE)
#  SET(BBTK_BOOST_LIBRARIES
#    boost_signals
#    )
#ENDIF(BBTK_USE_SHIPPED_BOOST)

ENDIF(BBTK_KERNEL OR BBTK_CORE_PACKAGE)
#-----------------------------------------------------------------------------



#-----------------------------------------------------------------------------
CREA_FIND_AND_USE_LIBRARIES()
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "")
MESSAGE(STATUS "=======================================") 
MESSAGE(STATUS "   ... ALL NEEDED LIBRARIES FOUND")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "")
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# bbtk library dependencies
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# WXWIDGETS
IF(BBTK_USE_WXWIDGETS)
  SET(BBTK_LINK_LIBRARIES
    ${BBTK_LINK_LIBRARIES}
    ${WXWIDGETS_LIBRARIES}
    )
ENDIF(BBTK_USE_WXWIDGETS)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# KWWIDGETS
IF(BBTK_USE_KWWIDGETS)
  SET(BBTK_LINK_LIBRARIES
    ${BBTK_LINK_LIBRARIES}
    ${KWWIDGETS_LIBRARIES} 
    )
ENDIF(BBTK_USE_KWWIDGETS)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# QT
IF(BBTK_USE_QT)
  SET(BBTK_LINK_LIBRARIES
    ${BBTK_LINK_LIBRARIES}
    ${QT_LIBRARIES} 
    )
ENDIF(BBTK_USE_QT)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# BOOST 
SET(BBTK_LINK_LIBRARIES
  ${BBTK_LINK_LIBRARIES}
  ${BBTK_BOOST_LIBRARIES} 
  ) 
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# On unix systems, need to link against dl for dynamic librairies open/close
IF(UNIX)
  SET(BBTK_LINK_LIBRARIES
    ${BBTK_LINK_LIBRARIES}
    dl) 
ENDIF(UNIX)
#-----------------------------------------------------------------------------

# mingw 
IF(MINGW)
  SET(BBTK_LINK_LIBRARIES
    ${BBTK_LINK_LIBRARIES}
    dl) 
ENDIF(MINGW)


#-----------------------------------------------------------------------------
MESSAGE(STATUS "")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "bbtk LINK LIBRARIES:")
MESSAGE(STATUS "${BBTK_LINK_LIBRARIES}")
MESSAGE(STATUS "=======================================")
MESSAGE(STATUS "")
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# EO bbtk library dependencies
#-----------------------------------------------------------------------------

