 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


MESSAGE(STATUS "===============================================")
MESSAGE(STATUS "Setting up deduced pathes:")
# Black box docs relative path
SET(BBTK_BBDOC_REL_PATH ${BBTK_DOC_REL_PATH}/bbdoc)
# Doxygen docs relative path
SET(BBTK_DOXYGEN_REL_PATH ${BBTK_DOC_REL_PATH}/doxygen)

MESSAGE(STATUS "* BBTK_BBDOC_REL_PATH   =${BBTK_BBDOC_REL_PATH}")
MESSAGE(STATUS "* BBTK_DOXYGEN_REL_PATH =${BBTK_DOXYGEN_REL_PATH}")

# Now compute BUILD TREE **ABSOLUTE PATHS**
SET(BBTK_DOC_BUILD_PATH ${PROJECT_BINARY_DIR}/${BBTK_DOC_REL_PATH})
SET(BBTK_BBDOC_BUILD_PATH ${PROJECT_BINARY_DIR}/${BBTK_BBDOC_REL_PATH})
SET(BBTK_DOXYGEN_BUILD_PATH ${PROJECT_BINARY_DIR}/${BBTK_DOXYGEN_REL_PATH})
SET(BBTK_BBS_BUILD_PATH ${PROJECT_BINARY_DIR}/${BBTK_BBS_REL_PATH})
SET(BBTK_DATA_BUILD_PATH ${PROJECT_BINARY_DIR}/${BBTK_DATA_REL_PATH})

#SET(BBTK_DOC_INSTALL_PATH ${BBTK_INSTALL_PREFIX}/${BBTK_DOC_REL_PATH})
#SET(BBTK_BBDOC_INSTALL_PATH ${BBTK_INSTALL_PREFIX}/${BBTK_BBDOC_REL_PATH})
#SET(BBTK_DOXYGEN_INSTALL_PATH ${BBTK_INSTALL_PREFIX}/${BBTK_DOXYGEN_REL_PATH})
#SET(BBTK_BBS_INSTALL_PATH ${BBTK_INSTALL_PREFIX}/${BBTK_BBS_REL_PATH})
#SET(BBTK_DATA_INSTALL_PATH ${BBTK_INSTALL_PREFIX}/${BBTK_DATA_REL_PATH})

# LG 22/10/08 : REMOVED THE **ABSOLUTE INSTALL PATH**
# was buggy when packaging
# consequences : 
#  1) generated packages are NOT relocatables 
#  2) they must be installed at the same prefix than bbtk
SET(BBTK_DOC_INSTALL_PATH     ${BBTK_DOC_REL_PATH})
SET(BBTK_BBDOC_INSTALL_PATH   ${BBTK_BBDOC_REL_PATH})
SET(BBTK_DOXYGEN_INSTALL_PATH ${BBTK_DOXYGEN_REL_PATH})
SET(BBTK_BBS_INSTALL_PATH     ${BBTK_BBS_REL_PATH})
SET(BBTK_DATA_INSTALL_PATH    ${BBTK_DATA_REL_PATH})




# Create build directories if necessary
CREA_MKDIR(${BBTK_DOC_BUILD_PATH})
CREA_MKDIR(${BBTK_BBDOC_BUILD_PATH})
CREA_MKDIR(${BBTK_DOXYGEN_BUILD_PATH})
CREA_MKDIR(${BBTK_BBS_BUILD_PATH})
CREA_MKDIR(${BBTK_DATA_BUILD_PATH})

#-----------------------------------------------------------------------------
SET (EXECUTABLE_OUTPUT_PATH 
  ${PROJECT_BINARY_DIR}/${EXECUTABLE_OUTPUT_REL_PATH})
SET (LIBRARY_OUTPUT_PATH    
  ${PROJECT_BINARY_DIR}/${LIBRARY_OUTPUT_REL_PATH})
#-----------------------------------------------------------------------------
MESSAGE(STATUS "* EXECUTABLE_OUTPUT_PATH=${EXECUTABLE_OUTPUT_PATH}")
MESSAGE(STATUS "* LIBRARY_OUTPUT_PATH   =${LIBRARY_OUTPUT_PATH}")

#-----------------------------------------------------------------------------
# Today CMakeCreateFindPackage is copied in BBTK_CMAKE_DIR
# When installed as a separate project will have to find it with FIND_PACKAGE
SET(CMakeCreateFindPackage_DIR ${BBTK_CMAKE_DIR})
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# Dependencies added only the first time !
IF(BBTK_CORE_PACKAGE)

  IF(EXISTS "${BBTK_BBI}")
    SET(BBTK_BBI_DEPENDENCY)
  ELSE(EXISTS "${BBTK_BBI}")
    SET(BBTK_BBI_DEPENDENCY ${BBTK_BBI})
  ENDIF(EXISTS "${BBTK_BBI}")
  
  IF(EXISTS "${BBTK_BBS2CPP}")
    SET(BBTK_BBS2CPP_DEPENDENCY)
  ELSE(EXISTS "${BBTK_BBS2CPP}")
    SET(BBTK_BBS2CPP_DEPENDENCY ${BBTK_BBS2CPP})
  ENDIF(EXISTS "${BBTK_BBS2CPP}")
  
  IF(EXISTS "${BBTK_BBFY}")
    SET(BBTK_BBFY_DEPENDENCY)
  ELSE(EXISTS "${BBTK_BBFY}")
    SET(BBTK_BBFY_DEPENDENCY ${BBTK_BBFY})
  ENDIF(EXISTS "${BBTK_BBFY}")

  IF(EXISTS "${BBTK_BBPCONFIGURATOR}")
    SET(BBTK_BBPCONFIGURATOR_DEPENDENCY)
  ELSE(EXISTS "${BBTK_BBPCONFIGURATOR}")
    SET(BBTK_BBPCONFIGURATOR_DEPENDENCY ${BBTK_BBPCONFIGURATOR})
  ENDIF(EXISTS "${BBTK_BBPCONFIGURATOR}")


ENDIF(BBTK_CORE_PACKAGE)
#-----------------------------------------------------------------------------


MESSAGE(STATUS "===============================================")


