# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


#=======================================================================
# Looks for WxWidgets
#=======================================================================
MACRO(CREA_FIND_WXWIDGETS)
  IF(WIN32)
#    # Search WXWIDGETS   
#    #  WXWINDOWS_LIBRARY         = full path to the wxWindows library and linker flags on unix
#    #  CMAKE_WX_CXX_FLAGS        = compiler flags for building wxWindows 
#    #  WXWINDOWS_INCLUDE_PATH    = include path of wxWindows
#    SET(WXWINDOWS_USE_GL 1)
#    #wxWidgets build related stuff
#    # DO NOT FORCE DEBUG LIBS !!
#    SET(WXW_USE_DEBUG OFF)
#    SET(WXW_USE_UNICODE OFF)
#    SET(WXW_USE_SHARED ON)
#    SET(WXW_USE_UNIV OFF)
#    SET(WXW_USE_MONO OFF)
#    SET(WXW_FILE_VERSION "28")
#    SET(WXW_VERSION "2.8")
#    #CMake Options
#    # Why forcing verbosity ?
#    # SET(CMAKE_VERBOSE_MAKEFILE TRUE)
#    INCLUDE (${CREA_CMAKE_DIR}/FindWxWidgetsWin32.cmake)
#    #
  
#  	find_package(wxwidgets REQUIRED COMPONENTS base core advanced adv html xml aui)
  	find_package(wxwidgets REQUIRED  )

  
  ELSE(WIN32)

	  MESSAGE ( "===============Manual wx-config 3 EED =======================")

##2018-08-28	  
 if(APPLE)
    message("EED CREAMacro_FindAndUseWxWidgets APPLE.  forsing wxWidgets_CONFIG_EXECUTABLE.   wxWidgets_wxrc_EXECUTABLE ")
  SET(wxWidgets_CONFIG_EXECUTABLE  /opt/local/Library/Frameworks/wxWidgets.framework/Versions/wxWidgets/3.1/bin/wx-config CACHE STRING wxWidgets_CONFIG_EXECUTABLE FORCE)
 	SET(wxWidgets_wxrc_EXECUTABLE   /opt/local/Library/Frameworks/wxWidgets.framework/Versions/wxWidgets/3.1/bin/wxrc-3.0 CACHE STRING wxWidgets_wxrc_EXECUTABLE FORCE)
 elseif(UNIX)
	    message("EED CREAMacro_FindAndUseWxWidgets UNIX")
		#MESSAGE ( "===============Manual wx-config 2 EED =======================")
		#SET(wxWidgets_CONFIG_EXECUTABLE /usr/bin/wx-config-2.0 CACHE STRING wxWidgets_CONFIG_EXECUTABLE FORCE)
		#SET(wxWidgets_wxrc_EXECUTABLE /usr/bin/wxrc-2.8 CACHE STRING wxWidgets_wxrc_EXECUTABLE FORCE)
      SET(wxWidgets_CONFIG_EXECUTABLE /usr/bin/wx-config-3.0 CACHE STRING wxWidgets_CONFIG_EXECUTABLE FORCE)
	  SET(wxWidgets_wxrc_EXECUTABLE /usr/bin/wxrc-3.0 CACHE STRING wxWidgets_wxrc_EXECUTABLE FORCE)
      	# CMake 2.6:
      	# technically those packages are not required 
      	# since one can still use the Motif/X11 version and not the gtk one:
      FIND_PACKAGE(PkgConfig REQUIRED)
      	##    pkg_check_modules (GTK2 gtk+-2.0)
      	##    pkg_check_modules (GTK322 gtk+-3.0)
      pkg_check_modules (GTK3 REQUIRED gtk+-3.0)
endif(APPLE)

      # Can I require all my user to have the gl lib on linux, even if they do not really need it...
      SET(WXGLCANVASLIBS "gl")	  

      SET(WXAUILIBS "aui")
      # LG : These options should be set by the user at top level of crea
      FIND_PACKAGE(wxWidgets REQUIRED COMPONENTS base core adv html
					${WXAUILIBS}
					${WXGLCANVASLIBS}	)
    IF(wxWidgets_FOUND)
      MESSAGE ( STATUS "=======================================")
      MESSAGE ( STATUS "Looking for wxWidgets... found ${wxWidgets_CONFIG_EXECUTABLE}")
    ENDIF(wxWidgets_FOUND)
    
  ENDIF(WIN32)
  
ENDMACRO(CREA_FIND_WXWIDGETS)
#=======================================================================

#=======================================================================
MACRO(CREA_USE_WXWIDGETS)
  # Preprocessor settings
  CREA_DEFINE( USE_WXWIDGETS )
  CREA_DEFINE( _USE_WXWIDGETS_ )

 #
  IF(WIN32)
#    # Clean ?
#    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}${WXWIDGETS_CXX_FLAGS}")
#    SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS}${WXWIDGETS_EXE_LINKER_FLAGS}")
#    #
#    ADD_DEFINITIONS( ${WXWIDGETS_DEFINITIONS}  )
#    #
#    INCLUDE_DIRECTORIES(${WXWIDGETS_INCLUDE_DIR})
#    LINK_DIRECTORIES( ${WXWIDGETS_LINK_DIRECTORIES} )
#    SET(WXWIDGETS_LIBRARIES
#      ${WXWIDGETS_LIBRARIES}  
##DO NOT FORCE DEBUG LIBS !!
#      debug wxmsw28d_aui
#      optimized wxmsw28_aui
#      debug msvcrtd
#      debug msvcprtd
#      optimized msvcrt
#      optimized msvcprt
#      )
	  
	include(${wxWidgets_USE_FILE})
	

	SET(WXWIDGETS_LIBRARIES ${wxWidgets_LIBRARIES}   
	            "${wxWidgets_LIB_DIR}/libwxmsw32u_aui.a"   
				"${wxWidgets_LIB_DIR}/libwxmsw32u_webview.a"    
				"${wxWidgets_LIB_DIR}/libwxmsw32u_html.a"   
				"${wxWidgets_LIB_DIR}/libwxmsw32u_adv.a" 
	            "${wxWidgets_LIB_DIR}/libwxmsw32u_gl.a"   
	            "${wxWidgets_LIB_DIR}/libwxmsw32u_media.a"   
	            "${wxWidgets_LIB_DIR}/libwxmsw32u_core.a"   
	            "${wxWidgets_LIB_DIR}/libwxbase32u.a"   
	            "${wxWidgets_LIB_DIR}/libwxbase32u_net.a"   
				)    	  
	
  ELSE(WIN32)
    IF(APPLE)
        INCLUDE( ${wxWidgets_USE_FILE} )
        MARK_AS_ADVANCED(wxWidgets_CONFIG_EXECUTABLE)
        SET(WXWIDGETS_LIBRARIES
            ${wxWidgets_LIBRARIES}
        )
    ELSEIF(UNIX)
		##    # GTK2
		##    INCLUDE_DIRECTORIES(${GTK2_INCLUDE_DIRS})
		##    LINK_DIRECTORIES(${GTK2_LIBRARY_DIRS})
		##    LINK_LIBRARIES(${GTK2_LIBRARIES})
    	# GTK3
        INCLUDE_DIRECTORIES(${GTK3_INCLUDE_DIRS})
        LINK_DIRECTORIES(${GTK3_LIBRARY_DIRS})
        LINK_LIBRARIES(${GTK3_LIBRARIES} )
		message("EED GTK3_VERSION "${GTK3_VERSION})
        message("EED GTK3_INCLUDE_DIRS "${GTK3_INCLUDE_DIRS})
        message("EED GTK3_LIBRARY_DIRS "${GTK3_LIBRARY_DIRS})
        message("EED GTK3_LIBRARIES "${GTK3_LIBRARIES})
    	# WX
		#    INCLUDE( ${GTK_USE_FILE} )
    	INCLUDE( ${wxWidgets_USE_FILE} )
    	MARK_AS_ADVANCED(wxWidgets_CONFIG_EXECUTABLE)
    	SET(WXWIDGETS_LIBRARIES
      		${GTK3_LIBRARIES}
      		${wxWidgets_LIBRARIES}      
		)
    ENDIF(APPLE)
  ENDIF(WIN32)
ENDMACRO(CREA_USE_WXWIDGETS)
#=======================================================================

#=======================================================================
MACRO(CREA_FIND_AND_USE_WXWIDGETS)
  CREA_FIND_WXWIDGETS()
  CREA_USE_WXWIDGETS()
ENDMACRO(CREA_FIND_AND_USE_WXWIDGETS)
#=======================================================================
