# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# This is an implementation detail for using creaEnvironment with the
# FindcreaEnvironment.cmake module.  Do not include directly by name.  
# This should be included only when FindcreaEnvironment.cmake sets 
# the creaEnvironment_USE_FILE variable to point here.

IF(CREA_VERBOSE_CMAKE)
  MESSAGE(STATUS "Using creaEnvironment")
ENDIF(CREA_VERBOSE_CMAKE)

# Load the compiler settings used for creaEnvironment.
IF(creaEnvironment_BUILD_SETTINGS_FILE)
  INCLUDE(CMakeImportBuildSettings)
  CMAKE_IMPORT_BUILD_SETTINGS(${creaEnvironment_BUILD_SETTINGS_FILE})
ENDIF(creaEnvironment_BUILD_SETTINGS_FILE)

# Add compiler flags needed to use creaEnvironment.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${creaEnvironment_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${creaEnvironment_REQUIRED_CXX_FLAGS}")
SET(CMAKE_LINK_FLAGS "${CMAKE_LINK_FLAGS} ${creaEnvironment_REQUIRED_LINK_FLAGS}")

# Add include directories needed to use creaEnvironment.
INCLUDE_DIRECTORIES(${creaEnvironment_INCLUDE_DIRS})

# Add link directories needed to use creaEnvironment.
LINK_DIRECTORIES(${creaEnvironment_LIBRARY_DIRS})

# Set the version 
# Already done in bbtkConfigure.h
#ADD_DEFINITIONS( -DcreaEnvironment_VERSION="\"${creaEnvironment_VERSION}\"" )

# Additional use file 
IF (creaEnvironment_HAS_ADDITIONAL_CONFIG_FILE)
  # Include it
  INCLUDE(${creaEnvironment_DIR}/AdditionalUsecreaEnvironment.cmake)
ENDIF (creaEnvironment_HAS_ADDITIONAL_CONFIG_FILE)
