# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if GUIWxVolumeRenderer is found.  
# If GUIWxVolumeRenderer is not found, GUIWxVolumeRenderer_FOUND is set to false.
#  GUIWxVolumeRenderer_FOUND         - Set to true when GUIWxVolumeRenderer is found.
#  GUIWxVolumeRenderer_USE_FILE      - CMake file to use GUIWxVolumeRenderer.
#  GUIWxVolumeRenderer_MAJOR_VERSION - The GUIWxVolumeRenderer major version number.
#  GUIWxVolumeRenderer_MINOR_VERSION - The GUIWxVolumeRenderer minor version number 
#                       (odd non-release).
#  GUIWxVolumeRenderer_BUILD_VERSION - The GUIWxVolumeRenderer patch level 
#                       (meaningless for odd minor).
#  GUIWxVolumeRenderer_INCLUDE_DIRS  - Include directories for GUIWxVolumeRenderer
#  GUIWxVolumeRenderer_LIBRARY_DIRS  - Link directories for GUIWxVolumeRenderer libraries
#  GUIWxVolumeRenderer_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate GUIWxVolumeRenderer:
#  GUIWxVolumeRenderer_DIR  - The directory containing GUIWxVolumeRendererConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/GUIWxVolumeRenderer directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(GUIWxVolumeRenderer_DIR_DESCRIPTION "directory containing GUIWxVolumeRendererConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/GUIWxVolumeRenderer for an installation.")
SET(GUIWxVolumeRenderer_NOT_FOUND_MESSAGE "GUIWxVolumeRenderer not found.  Set the GUIWxVolumeRenderer_DIR cmake cache entry to the ${GUIWxVolumeRenderer_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT GUIWxVolumeRenderer_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" GUIWxVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" GUIWxVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" GUIWxVolumeRenderer_DIR_SEARCH2 "${GUIWxVolumeRenderer_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(GUIWxVolumeRenderer_DIR_SEARCH "")
  FOREACH(dir ${GUIWxVolumeRenderer_DIR_SEARCH2})
    SET(GUIWxVolumeRenderer_DIR_SEARCH ${GUIWxVolumeRenderer_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(GUIWxVolumeRenderer_DIR UseGUIWxVolumeRenderer.cmake
    # Look for an environment variable GUIWxVolumeRenderer_DIR.
    $ENV{GUIWxVolumeRenderer_DIR}

    # Look in places relative to the system executable search path.
    ${GUIWxVolumeRenderer_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/GUIWxVolumeRenderer"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaMaracasVisu
    /usr/lib/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # GUIWxVolumeRenderer will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${GUIWxVolumeRenderer_DIR_DESCRIPTION}"
  )
ENDIF(NOT GUIWxVolumeRenderer_DIR)

# If GUIWxVolumeRenderer was found, load the configuration file to get the rest of the
# settings.
IF(GUIWxVolumeRenderer_DIR)
  # Make sure the GUIWxVolumeRendererConfig.cmake file exists in the directory provided.
  IF(EXISTS ${GUIWxVolumeRenderer_DIR}/GUIWxVolumeRendererConfig.cmake)

    # We found GUIWxVolumeRenderer.  Load the settings.
    SET(GUIWxVolumeRenderer_FOUND 1)
    INCLUDE(${GUIWxVolumeRenderer_DIR}/GUIWxVolumeRendererConfig.cmake)

  ENDIF(EXISTS ${GUIWxVolumeRenderer_DIR}/GUIWxVolumeRendererConfig.cmake)
ELSE(GUIWxVolumeRenderer_DIR)
  # We did not find GUIWxVolumeRenderer.
  SET(GUIWxVolumeRenderer_FOUND 0)
ENDIF(GUIWxVolumeRenderer_DIR)

#-----------------------------------------------------------------------------
IF(NOT GUIWxVolumeRenderer_FOUND)
  # GUIWxVolumeRenderer not found, explain to the user how to specify its location.
  IF(NOT GUIWxVolumeRenderer_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${GUIWxVolumeRenderer_NOT_FOUND_MESSAGE})
  ELSE(NOT GUIWxVolumeRenderer_FIND_QUIETLY)
    IF(GUIWxVolumeRenderer_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${GUIWxVolumeRenderer_NOT_FOUND_MESSAGE})
    ENDIF(GUIWxVolumeRenderer_FIND_REQUIRED)
  ENDIF(NOT GUIWxVolumeRenderer_FIND_QUIETLY)
ENDIF(NOT GUIWxVolumeRenderer_FOUND)
