# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if KernelSurfaceRenderer is found.  
# If KernelSurfaceRenderer is not found, KernelSurfaceRenderer_FOUND is set to false.
#  KernelSurfaceRenderer_FOUND         - Set to true when KernelSurfaceRenderer is found.
#  KernelSurfaceRenderer_USE_FILE      - CMake file to use KernelSurfaceRenderer.
#  KernelSurfaceRenderer_MAJOR_VERSION - The KernelSurfaceRenderer major version number.
#  KernelSurfaceRenderer_MINOR_VERSION - The KernelSurfaceRenderer minor version number 
#                       (odd non-release).
#  KernelSurfaceRenderer_BUILD_VERSION - The KernelSurfaceRenderer patch level 
#                       (meaningless for odd minor).
#  KernelSurfaceRenderer_INCLUDE_DIRS  - Include directories for KernelSurfaceRenderer
#  KernelSurfaceRenderer_LIBRARY_DIRS  - Link directories for KernelSurfaceRenderer libraries
#  KernelSurfaceRenderer_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate KernelSurfaceRenderer:
#  KernelSurfaceRenderer_DIR  - The directory containing KernelSurfaceRendererConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/KernelSurfaceRenderer directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(KernelSurfaceRenderer_DIR_DESCRIPTION "directory containing KernelSurfaceRendererConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/KernelSurfaceRenderer for an installation.")
SET(KernelSurfaceRenderer_NOT_FOUND_MESSAGE "KernelSurfaceRenderer not found.  Set the KernelSurfaceRenderer_DIR cmake cache entry to the ${KernelSurfaceRenderer_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT KernelSurfaceRenderer_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" KernelSurfaceRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" KernelSurfaceRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" KernelSurfaceRenderer_DIR_SEARCH2 "${KernelSurfaceRenderer_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(KernelSurfaceRenderer_DIR_SEARCH "")
  FOREACH(dir ${KernelSurfaceRenderer_DIR_SEARCH2})
    SET(KernelSurfaceRenderer_DIR_SEARCH ${KernelSurfaceRenderer_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(KernelSurfaceRenderer_DIR UseKernelSurfaceRenderer.cmake
    # Look for an environment variable KernelSurfaceRenderer_DIR.
    $ENV{KernelSurfaceRenderer_DIR}

    # Look in places relative to the system executable search path.
    ${KernelSurfaceRenderer_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/KernelSurfaceRenderer"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaMaracasVisu
    /usr/lib/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # KernelSurfaceRenderer will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${KernelSurfaceRenderer_DIR_DESCRIPTION}"
  )
ENDIF(NOT KernelSurfaceRenderer_DIR)

# If KernelSurfaceRenderer was found, load the configuration file to get the rest of the
# settings.
IF(KernelSurfaceRenderer_DIR)
  # Make sure the KernelSurfaceRendererConfig.cmake file exists in the directory provided.
  IF(EXISTS ${KernelSurfaceRenderer_DIR}/KernelSurfaceRendererConfig.cmake)

    # We found KernelSurfaceRenderer.  Load the settings.
    SET(KernelSurfaceRenderer_FOUND 1)
    INCLUDE(${KernelSurfaceRenderer_DIR}/KernelSurfaceRendererConfig.cmake)

  ENDIF(EXISTS ${KernelSurfaceRenderer_DIR}/KernelSurfaceRendererConfig.cmake)
ELSE(KernelSurfaceRenderer_DIR)
  # We did not find KernelSurfaceRenderer.
  SET(KernelSurfaceRenderer_FOUND 0)
ENDIF(KernelSurfaceRenderer_DIR)

#-----------------------------------------------------------------------------
IF(NOT KernelSurfaceRenderer_FOUND)
  # KernelSurfaceRenderer not found, explain to the user how to specify its location.
  IF(NOT KernelSurfaceRenderer_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${KernelSurfaceRenderer_NOT_FOUND_MESSAGE})
  ELSE(NOT KernelSurfaceRenderer_FIND_QUIETLY)
    IF(KernelSurfaceRenderer_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${KernelSurfaceRenderer_NOT_FOUND_MESSAGE})
    ENDIF(KernelSurfaceRenderer_FIND_REQUIRED)
  ENDIF(NOT KernelSurfaceRenderer_FIND_QUIETLY)
ENDIF(NOT KernelSurfaceRenderer_FOUND)
