# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if KernelViewerWidgets is found.  
# If KernelViewerWidgets is not found, KernelViewerWidgets_FOUND is set to false.
#  KernelViewerWidgets_FOUND         - Set to true when KernelViewerWidgets is found.
#  KernelViewerWidgets_USE_FILE      - CMake file to use KernelViewerWidgets.
#  KernelViewerWidgets_MAJOR_VERSION - The KernelViewerWidgets major version number.
#  KernelViewerWidgets_MINOR_VERSION - The KernelViewerWidgets minor version number 
#                       (odd non-release).
#  KernelViewerWidgets_BUILD_VERSION - The KernelViewerWidgets patch level 
#                       (meaningless for odd minor).
#  KernelViewerWidgets_INCLUDE_DIRS  - Include directories for KernelViewerWidgets
#  KernelViewerWidgets_LIBRARY_DIRS  - Link directories for KernelViewerWidgets libraries
#  KernelViewerWidgets_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate KernelViewerWidgets:
#  KernelViewerWidgets_DIR  - The directory containing KernelViewerWidgetsConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/KernelViewerWidgets directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(KernelViewerWidgets_DIR_DESCRIPTION "directory containing KernelViewerWidgetsConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/KernelViewerWidgets for an installation.")
SET(KernelViewerWidgets_NOT_FOUND_MESSAGE "KernelViewerWidgets not found.  Set the KernelViewerWidgets_DIR cmake cache entry to the ${KernelViewerWidgets_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT KernelViewerWidgets_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" KernelViewerWidgets_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" KernelViewerWidgets_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" KernelViewerWidgets_DIR_SEARCH2 "${KernelViewerWidgets_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(KernelViewerWidgets_DIR_SEARCH "")
  FOREACH(dir ${KernelViewerWidgets_DIR_SEARCH2})
    SET(KernelViewerWidgets_DIR_SEARCH ${KernelViewerWidgets_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(KernelViewerWidgets_DIR UseKernelViewerWidgets.cmake
    # Look for an environment variable KernelViewerWidgets_DIR.
    $ENV{KernelViewerWidgets_DIR}

    # Look in places relative to the system executable search path.
    ${KernelViewerWidgets_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/KernelViewerWidgets"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaMaracasVisu
    /usr/lib/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # KernelViewerWidgets will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${KernelViewerWidgets_DIR_DESCRIPTION}"
  )
ENDIF(NOT KernelViewerWidgets_DIR)

# If KernelViewerWidgets was found, load the configuration file to get the rest of the
# settings.
IF(KernelViewerWidgets_DIR)
  # Make sure the KernelViewerWidgetsConfig.cmake file exists in the directory provided.
  IF(EXISTS ${KernelViewerWidgets_DIR}/KernelViewerWidgetsConfig.cmake)

    # We found KernelViewerWidgets.  Load the settings.
    SET(KernelViewerWidgets_FOUND 1)
    INCLUDE(${KernelViewerWidgets_DIR}/KernelViewerWidgetsConfig.cmake)

  ENDIF(EXISTS ${KernelViewerWidgets_DIR}/KernelViewerWidgetsConfig.cmake)
ELSE(KernelViewerWidgets_DIR)
  # We did not find KernelViewerWidgets.
  SET(KernelViewerWidgets_FOUND 0)
ENDIF(KernelViewerWidgets_DIR)

#-----------------------------------------------------------------------------
IF(NOT KernelViewerWidgets_FOUND)
  # KernelViewerWidgets not found, explain to the user how to specify its location.
  IF(NOT KernelViewerWidgets_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${KernelViewerWidgets_NOT_FOUND_MESSAGE})
  ELSE(NOT KernelViewerWidgets_FIND_QUIETLY)
    IF(KernelViewerWidgets_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${KernelViewerWidgets_NOT_FOUND_MESSAGE})
    ENDIF(KernelViewerWidgets_FIND_REQUIRED)
  ENDIF(NOT KernelViewerWidgets_FIND_QUIETLY)
ENDIF(NOT KernelViewerWidgets_FOUND)
