# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if KernelVolumeRenderer is found.  
# If KernelVolumeRenderer is not found, KernelVolumeRenderer_FOUND is set to false.
#  KernelVolumeRenderer_FOUND         - Set to true when KernelVolumeRenderer is found.
#  KernelVolumeRenderer_USE_FILE      - CMake file to use KernelVolumeRenderer.
#  KernelVolumeRenderer_MAJOR_VERSION - The KernelVolumeRenderer major version number.
#  KernelVolumeRenderer_MINOR_VERSION - The KernelVolumeRenderer minor version number 
#                       (odd non-release).
#  KernelVolumeRenderer_BUILD_VERSION - The KernelVolumeRenderer patch level 
#                       (meaningless for odd minor).
#  KernelVolumeRenderer_INCLUDE_DIRS  - Include directories for KernelVolumeRenderer
#  KernelVolumeRenderer_LIBRARY_DIRS  - Link directories for KernelVolumeRenderer libraries
#  KernelVolumeRenderer_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate KernelVolumeRenderer:
#  KernelVolumeRenderer_DIR  - The directory containing KernelVolumeRendererConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/KernelVolumeRenderer directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(KernelVolumeRenderer_DIR_DESCRIPTION "directory containing KernelVolumeRendererConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/KernelVolumeRenderer for an installation.")
SET(KernelVolumeRenderer_NOT_FOUND_MESSAGE "KernelVolumeRenderer not found.  Set the KernelVolumeRenderer_DIR cmake cache entry to the ${KernelVolumeRenderer_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT KernelVolumeRenderer_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" KernelVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" KernelVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" KernelVolumeRenderer_DIR_SEARCH2 "${KernelVolumeRenderer_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(KernelVolumeRenderer_DIR_SEARCH "")
  FOREACH(dir ${KernelVolumeRenderer_DIR_SEARCH2})
    SET(KernelVolumeRenderer_DIR_SEARCH ${KernelVolumeRenderer_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(KernelVolumeRenderer_DIR UseKernelVolumeRenderer.cmake
    # Look for an environment variable KernelVolumeRenderer_DIR.
    $ENV{KernelVolumeRenderer_DIR}

    # Look in places relative to the system executable search path.
    ${KernelVolumeRenderer_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/KernelVolumeRenderer"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaMaracasVisu
    /usr/lib/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # KernelVolumeRenderer will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${KernelVolumeRenderer_DIR_DESCRIPTION}"
  )
ENDIF(NOT KernelVolumeRenderer_DIR)

# If KernelVolumeRenderer was found, load the configuration file to get the rest of the
# settings.
IF(KernelVolumeRenderer_DIR)
  # Make sure the KernelVolumeRendererConfig.cmake file exists in the directory provided.
  IF(EXISTS ${KernelVolumeRenderer_DIR}/KernelVolumeRendererConfig.cmake)

    # We found KernelVolumeRenderer.  Load the settings.
    SET(KernelVolumeRenderer_FOUND 1)
    INCLUDE(${KernelVolumeRenderer_DIR}/KernelVolumeRendererConfig.cmake)

  ENDIF(EXISTS ${KernelVolumeRenderer_DIR}/KernelVolumeRendererConfig.cmake)
ELSE(KernelVolumeRenderer_DIR)
  # We did not find KernelVolumeRenderer.
  SET(KernelVolumeRenderer_FOUND 0)
ENDIF(KernelVolumeRenderer_DIR)

#-----------------------------------------------------------------------------
IF(NOT KernelVolumeRenderer_FOUND)
  # KernelVolumeRenderer not found, explain to the user how to specify its location.
  IF(NOT KernelVolumeRenderer_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${KernelVolumeRenderer_NOT_FOUND_MESSAGE})
  ELSE(NOT KernelVolumeRenderer_FIND_QUIETLY)
    IF(KernelVolumeRenderer_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${KernelVolumeRenderer_NOT_FOUND_MESSAGE})
    ENDIF(KernelVolumeRenderer_FIND_REQUIRED)
  ENDIF(NOT KernelVolumeRenderer_FIND_QUIETLY)
ENDIF(NOT KernelVolumeRenderer_FOUND)
