# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if ___Library_name___here___ is found.  
# If ___Library_name___here___ is not found, ___Library_name___here____FOUND is set to false.
#  ___Library_name___here____FOUND         - Set to true when ___Library_name___here___ is found.
#  ___Library_name___here____USE_FILE      - CMake file to use ___Library_name___here___.
#  ___Library_name___here____MAJOR_VERSION - The ___Library_name___here___ major version number.
#  ___Library_name___here____MINOR_VERSION - The ___Library_name___here___ minor version number 
#                       (odd non-release).
#  ___Library_name___here____BUILD_VERSION - The ___Library_name___here___ patch level 
#                       (meaningless for odd minor).
#  ___Library_name___here____INCLUDE_DIRS  - Include directories for ___Library_name___here___
#  ___Library_name___here____LIBRARY_DIRS  - Link directories for ___Library_name___here___ libraries
#  ___Library_name___here____LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate ___Library_name___here___:
#  ___Library_name___here____DIR  - The directory containing ___Library_name___here___Config.cmake.  
#             This is either the root of the build tree,
#             or the lib/___Library_name___here___ directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(___Library_name___here____DIR_DESCRIPTION "directory containing ___Library_name___here___Config.cmake.  This is either the root of the build tree, or PREFIX/lib/___Library_name___here___ for an installation.")
SET(___Library_name___here____NOT_FOUND_MESSAGE "___Library_name___here___ not found.  Set the ___Library_name___here____DIR cmake cache entry to the ${___Library_name___here____DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT ___Library_name___here____DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" ___Library_name___here____DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" ___Library_name___here____DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" ___Library_name___here____DIR_SEARCH2 "${___Library_name___here____DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(___Library_name___here____DIR_SEARCH "")
  FOREACH(dir ${___Library_name___here____DIR_SEARCH2})
    SET(___Library_name___here____DIR_SEARCH ${___Library_name___here____DIR_SEARCH}
      ${dir}/../lib/lib/creatools/___Library_name___here___
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(___Library_name___here____DIR Use___Library_name___here___.cmake
    # Look for an environment variable ___Library_name___here____DIR.
    $ENV{___Library_name___here____DIR}

    # Look in places relative to the system executable search path.
    ${___Library_name___here____DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/___Library_name___here___"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/___Library_name___here___
    /usr/lib/creatools/___Library_name___here___

    # Read from the CMakeSetup registry entries.  It is likely that
    # ___Library_name___here___ will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${___Library_name___here____DIR_DESCRIPTION}"
  )
ENDIF(NOT ___Library_name___here____DIR)

# If ___Library_name___here___ was found, load the configuration file to get the rest of the
# settings.
IF(___Library_name___here____DIR)
  # Make sure the ___Library_name___here___Config.cmake file exists in the directory provided.
  IF(EXISTS ${___Library_name___here____DIR}/___Library_name___here___Config.cmake)

    # We found ___Library_name___here___.  Load the settings.
    SET(___Library_name___here____FOUND 1)
    INCLUDE(${___Library_name___here____DIR}/___Library_name___here___Config.cmake)

  ENDIF(EXISTS ${___Library_name___here____DIR}/___Library_name___here___Config.cmake)
ELSE(___Library_name___here____DIR)
  # We did not find ___Library_name___here___.
  SET(___Library_name___here____FOUND 0)
ENDIF(___Library_name___here____DIR)

#-----------------------------------------------------------------------------
IF(NOT ___Library_name___here____FOUND)
  # ___Library_name___here___ not found, explain to the user how to specify its location.
  IF(NOT ___Library_name___here____FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${___Library_name___here____NOT_FOUND_MESSAGE})
  ELSE(NOT ___Library_name___here____FIND_QUIETLY)
    IF(___Library_name___here____FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${___Library_name___here____NOT_FOUND_MESSAGE})
    ENDIF(___Library_name___here____FIND_REQUIRED)
  ENDIF(NOT ___Library_name___here____FIND_QUIETLY)
ENDIF(NOT ___Library_name___here____FOUND)
