# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbTransform3Ddicom is found.  
# If bbTransform3Ddicom is not found, bbTransform3Ddicom_FOUND is set to false.
#  bbTransform3Ddicom_FOUND         - Set to true when bbTransform3Ddicom is found.
#  bbTransform3Ddicom_USE_FILE      - CMake file to use bbTransform3Ddicom.
#  bbTransform3Ddicom_MAJOR_VERSION - The bbTransform3Ddicom major version number.
#  bbTransform3Ddicom_MINOR_VERSION - The bbTransform3Ddicom minor version number 
#                       (odd non-release).
#  bbTransform3Ddicom_BUILD_VERSION - The bbTransform3Ddicom patch level 
#                       (meaningless for odd minor).
#  bbTransform3Ddicom_INCLUDE_DIRS  - Include directories for bbTransform3Ddicom
#  bbTransform3Ddicom_LIBRARY_DIRS  - Link directories for bbTransform3Ddicom libraries
#  bbTransform3Ddicom_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbTransform3Ddicom:
#  bbTransform3Ddicom_DIR  - The directory containing bbTransform3DdicomConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbTransform3Ddicom directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbTransform3Ddicom_DIR_DESCRIPTION "directory containing bbTransform3DdicomConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbTransform3Ddicom for an installation.")
SET(bbTransform3Ddicom_NOT_FOUND_MESSAGE "bbTransform3Ddicom not found.  Set the bbTransform3Ddicom_DIR cmake cache entry to the ${bbTransform3Ddicom_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbTransform3Ddicom_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbTransform3Ddicom_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbTransform3Ddicom_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbTransform3Ddicom_DIR_SEARCH2 "${bbTransform3Ddicom_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbTransform3Ddicom_DIR_SEARCH "")
  FOREACH(dir ${bbTransform3Ddicom_DIR_SEARCH2})
    SET(bbTransform3Ddicom_DIR_SEARCH ${bbTransform3Ddicom_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/bbTransform3Ddicom
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbTransform3Ddicom_DIR UsebbTransform3Ddicom.cmake
    # Look for an environment variable bbTransform3Ddicom_DIR.
    $ENV{bbTransform3Ddicom_DIR}

    # Look in places relative to the system executable search path.
    ${bbTransform3Ddicom_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbTransform3Ddicom"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/bbTransform3Ddicom
    /usr/lib/creatools/bbTransform3Ddicom

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbTransform3Ddicom will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbTransform3Ddicom_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbTransform3Ddicom_DIR)

# If bbTransform3Ddicom was found, load the configuration file to get the rest of the
# settings.
IF(bbTransform3Ddicom_DIR)
  # Make sure the bbTransform3DdicomConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbTransform3Ddicom_DIR}/bbTransform3DdicomConfig.cmake)

    # We found bbTransform3Ddicom.  Load the settings.
    SET(bbTransform3Ddicom_FOUND 1)
    INCLUDE(${bbTransform3Ddicom_DIR}/bbTransform3DdicomConfig.cmake)

  ENDIF(EXISTS ${bbTransform3Ddicom_DIR}/bbTransform3DdicomConfig.cmake)
ELSE(bbTransform3Ddicom_DIR)
  # We did not find bbTransform3Ddicom.
  SET(bbTransform3Ddicom_FOUND 0)
ENDIF(bbTransform3Ddicom_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbTransform3Ddicom_FOUND)
  # bbTransform3Ddicom not found, explain to the user how to specify its location.
  IF(NOT bbTransform3Ddicom_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbTransform3Ddicom_NOT_FOUND_MESSAGE})
  ELSE(NOT bbTransform3Ddicom_FIND_QUIETLY)
    IF(bbTransform3Ddicom_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbTransform3Ddicom_NOT_FOUND_MESSAGE})
    ENDIF(bbTransform3Ddicom_FIND_REQUIRED)
  ENDIF(NOT bbTransform3Ddicom_FIND_QUIETLY)
ENDIF(NOT bbTransform3Ddicom_FOUND)
