# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbappli is found.  
# If bbappli is not found, bbappli_FOUND is set to false.
#  bbappli_FOUND         - Set to true when bbappli is found.
#  bbappli_USE_FILE      - CMake file to use bbappli.
#  bbappli_MAJOR_VERSION - The bbappli major version number.
#  bbappli_MINOR_VERSION - The bbappli minor version number 
#                       (odd non-release).
#  bbappli_BUILD_VERSION - The bbappli patch level 
#                       (meaningless for odd minor).
#  bbappli_INCLUDE_DIRS  - Include directories for bbappli
#  bbappli_LIBRARY_DIRS  - Link directories for bbappli libraries
#  bbappli_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbappli:
#  bbappli_DIR  - The directory containing bbappliConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbappli directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbappli_DIR_DESCRIPTION "directory containing bbappliConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbappli for an installation.")
SET(bbappli_NOT_FOUND_MESSAGE "bbappli not found.  Set the bbappli_DIR cmake cache entry to the ${bbappli_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbappli_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbappli_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbappli_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbappli_DIR_SEARCH2 "${bbappli_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbappli_DIR_SEARCH "")
  FOREACH(dir ${bbappli_DIR_SEARCH2})
    SET(bbappli_DIR_SEARCH ${bbappli_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/bbappli
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbappli_DIR Usebbappli.cmake
    # Look for an environment variable bbappli_DIR.
    $ENV{bbappli_DIR}

    # Look in places relative to the system executable search path.
    ${bbappli_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbappli"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/bbappli
    /usr/lib/creatools/bbappli

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbappli will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbappli_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbappli_DIR)

# If bbappli was found, load the configuration file to get the rest of the
# settings.
IF(bbappli_DIR)
  # Make sure the bbappliConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbappli_DIR}/bbappliConfig.cmake)

    # We found bbappli.  Load the settings.
    SET(bbappli_FOUND 1)
    INCLUDE(${bbappli_DIR}/bbappliConfig.cmake)

  ENDIF(EXISTS ${bbappli_DIR}/bbappliConfig.cmake)
ELSE(bbappli_DIR)
  # We did not find bbappli.
  SET(bbappli_FOUND 0)
ENDIF(bbappli_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbappli_FOUND)
  # bbappli not found, explain to the user how to specify its location.
  IF(NOT bbappli_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbappli_NOT_FOUND_MESSAGE})
  ELSE(NOT bbappli_FIND_QUIETLY)
    IF(bbappli_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbappli_NOT_FOUND_MESSAGE})
    ENDIF(bbappli_FIND_REQUIRED)
  ENDIF(NOT bbappli_FIND_QUIETLY)
ENDIF(NOT bbappli_FOUND)
