# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbitk is found.  
# If bbitk is not found, bbitk_FOUND is set to false.
#  bbitk_FOUND         - Set to true when bbitk is found.
#  bbitk_USE_FILE      - CMake file to use bbitk.
#  bbitk_MAJOR_VERSION - The bbitk major version number.
#  bbitk_MINOR_VERSION - The bbitk minor version number 
#                       (odd non-release).
#  bbitk_BUILD_VERSION - The bbitk patch level 
#                       (meaningless for odd minor).
#  bbitk_INCLUDE_DIRS  - Include directories for bbitk
#  bbitk_LIBRARY_DIRS  - Link directories for bbitk libraries
#  bbitk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbitk:
#  bbitk_DIR  - The directory containing bbitkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbitk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbitk_DIR_DESCRIPTION "directory containing bbitkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbitk for an installation.")
SET(bbitk_NOT_FOUND_MESSAGE "bbitk not found.  Set the bbitk_DIR cmake cache entry to the ${bbitk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbitk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbitk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbitk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbitk_DIR_SEARCH2 "${bbitk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbitk_DIR_SEARCH "")
  FOREACH(dir ${bbitk_DIR_SEARCH2})
    SET(bbitk_DIR_SEARCH ${bbitk_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/bbitk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbitk_DIR Usebbitk.cmake
    # Look for an environment variable bbitk_DIR.
    $ENV{bbitk_DIR}

    # Look in places relative to the system executable search path.
    ${bbitk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbitk"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/bbitk
    /usr/lib/creatools/bbitk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbitk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbitk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbitk_DIR)

# If bbitk was found, load the configuration file to get the rest of the
# settings.
IF(bbitk_DIR)
  # Make sure the bbitkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbitk_DIR}/bbitkConfig.cmake)

    # We found bbitk.  Load the settings.
    SET(bbitk_FOUND 1)
    INCLUDE(${bbitk_DIR}/bbitkConfig.cmake)

  ENDIF(EXISTS ${bbitk_DIR}/bbitkConfig.cmake)
ELSE(bbitk_DIR)
  # We did not find bbitk.
  SET(bbitk_FOUND 0)
ENDIF(bbitk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbitk_FOUND)
  # bbitk not found, explain to the user how to specify its location.
  IF(NOT bbitk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbitk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbitk_FIND_QUIETLY)
    IF(bbitk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbitk_NOT_FOUND_MESSAGE})
    ENDIF(bbitk_FIND_REQUIRED)
  ENDIF(NOT bbitk_FIND_QUIETLY)
ENDIF(NOT bbitk_FOUND)
