# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbstd is found.  
# If bbstd is not found, bbstd_FOUND is set to false.
#  bbstd_FOUND         - Set to true when bbstd is found.
#  bbstd_USE_FILE      - CMake file to use bbstd.
#  bbstd_MAJOR_VERSION - The bbstd major version number.
#  bbstd_MINOR_VERSION - The bbstd minor version number 
#                       (odd non-release).
#  bbstd_BUILD_VERSION - The bbstd patch level 
#                       (meaningless for odd minor).
#  bbstd_INCLUDE_DIRS  - Include directories for bbstd
#  bbstd_LIBRARY_DIRS  - Link directories for bbstd libraries
#  bbstd_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbstd:
#  bbstd_DIR  - The directory containing bbstdConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbstd directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbstd_DIR_DESCRIPTION "directory containing bbstdConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbstd for an installation.")
SET(bbstd_NOT_FOUND_MESSAGE "bbstd not found.  Set the bbstd_DIR cmake cache entry to the ${bbstd_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbstd_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbstd_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbstd_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbstd_DIR_SEARCH2 "${bbstd_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbstd_DIR_SEARCH "")
  FOREACH(dir ${bbstd_DIR_SEARCH2})
    SET(bbstd_DIR_SEARCH ${bbstd_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/bbstd
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbstd_DIR Usebbstd.cmake
    # Look for an environment variable bbstd_DIR.
    $ENV{bbstd_DIR}

    # Look in places relative to the system executable search path.
    ${bbstd_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbstd"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/bbstd
    /usr/lib/creatools/bbstd

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbstd will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbstd_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbstd_DIR)

# If bbstd was found, load the configuration file to get the rest of the
# settings.
IF(bbstd_DIR)
  # Make sure the bbstdConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbstd_DIR}/bbstdConfig.cmake)

    # We found bbstd.  Load the settings.
    SET(bbstd_FOUND 1)
    INCLUDE(${bbstd_DIR}/bbstdConfig.cmake)

  ENDIF(EXISTS ${bbstd_DIR}/bbstdConfig.cmake)
ELSE(bbstd_DIR)
  # We did not find bbstd.
  SET(bbstd_FOUND 0)
ENDIF(bbstd_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbstd_FOUND)
  # bbstd not found, explain to the user how to specify its location.
  IF(NOT bbstd_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbstd_NOT_FOUND_MESSAGE})
  ELSE(NOT bbstd_FIND_QUIETLY)
    IF(bbstd_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbstd_NOT_FOUND_MESSAGE})
    ENDIF(bbstd_FIND_REQUIRED)
  ENDIF(NOT bbstd_FIND_QUIETLY)
ENDIF(NOT bbstd_FOUND)
