# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if crea is found.  
# If crea is not found, crea_FOUND is set to false.
#  crea_FOUND         - Set to true when crea is found.
#  crea_USE_FILE      - CMake file to use crea.
#  crea_MAJOR_VERSION - The crea major version number.
#  crea_MINOR_VERSION - The crea minor version number 
#                       (odd non-release).
#  crea_BUILD_VERSION - The crea patch level 
#                       (meaningless for odd minor).
#  crea_INCLUDE_DIRS  - Include directories for crea
#  crea_LIBRARY_DIRS  - Link directories for crea libraries
#  crea_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate crea:
#  crea_DIR  - The directory containing creaConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/crea directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(crea_DIR_DESCRIPTION "directory containing creaConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/crea for an installation.")
SET(crea_NOT_FOUND_MESSAGE "crea not found.  Set the crea_DIR cmake cache entry to the ${crea_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT crea_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" crea_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" crea_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" crea_DIR_SEARCH2 "${crea_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(crea_DIR_SEARCH "")
  FOREACH(dir ${crea_DIR_SEARCH2})
    SET(crea_DIR_SEARCH ${crea_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/crea
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(crea_DIR Usecrea.cmake
    # Look for an environment variable crea_DIR.
    $ENV{crea_DIR}

    # Look in places relative to the system executable search path.
    ${crea_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/crea"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/crea
    /usr/lib/creatools/crea

    # Read from the CMakeSetup registry entries.  It is likely that
    # crea will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${crea_DIR_DESCRIPTION}"
  )
ENDIF(NOT crea_DIR)

# If crea was found, load the configuration file to get the rest of the
# settings.
IF(crea_DIR)
  # Make sure the creaConfig.cmake file exists in the directory provided.
  IF(EXISTS ${crea_DIR}/creaConfig.cmake)

    # We found crea.  Load the settings.
    SET(crea_FOUND 1)
    INCLUDE(${crea_DIR}/creaConfig.cmake)

  ENDIF(EXISTS ${crea_DIR}/creaConfig.cmake)
ELSE(crea_DIR)
  # We did not find crea.
  SET(crea_FOUND 0)
ENDIF(crea_DIR)

#-----------------------------------------------------------------------------
IF(NOT crea_FOUND)
  # crea not found, explain to the user how to specify its location.
  IF(NOT crea_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${crea_NOT_FOUND_MESSAGE})
  ELSE(NOT crea_FIND_QUIETLY)
    IF(crea_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${crea_NOT_FOUND_MESSAGE})
    ENDIF(crea_FIND_REQUIRED)
  ENDIF(NOT crea_FIND_QUIETLY)
ENDIF(NOT crea_FOUND)
