# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaDevManagerLib is found.  
# If creaDevManagerLib is not found, creaDevManagerLib_FOUND is set to false.
#  creaDevManagerLib_FOUND         - Set to true when creaDevManagerLib is found.
#  creaDevManagerLib_USE_FILE      - CMake file to use creaDevManagerLib.
#  creaDevManagerLib_MAJOR_VERSION - The creaDevManagerLib major version number.
#  creaDevManagerLib_MINOR_VERSION - The creaDevManagerLib minor version number 
#                       (odd non-release).
#  creaDevManagerLib_BUILD_VERSION - The creaDevManagerLib patch level 
#                       (meaningless for odd minor).
#  creaDevManagerLib_INCLUDE_DIRS  - Include directories for creaDevManagerLib
#  creaDevManagerLib_LIBRARY_DIRS  - Link directories for creaDevManagerLib libraries
#  creaDevManagerLib_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaDevManagerLib:
#  creaDevManagerLib_DIR  - The directory containing creaDevManagerLibConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaDevManagerLib directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaDevManagerLib_DIR_DESCRIPTION "directory containing creaDevManagerLibConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaDevManagerLib for an installation.")
SET(creaDevManagerLib_NOT_FOUND_MESSAGE "creaDevManagerLib not found.  Set the creaDevManagerLib_DIR cmake cache entry to the ${creaDevManagerLib_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaDevManagerLib_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaDevManagerLib_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaDevManagerLib_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaDevManagerLib_DIR_SEARCH2 "${creaDevManagerLib_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaDevManagerLib_DIR_SEARCH "")
  FOREACH(dir ${creaDevManagerLib_DIR_SEARCH2})
    SET(creaDevManagerLib_DIR_SEARCH ${creaDevManagerLib_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaDevManagerLib
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaDevManagerLib_DIR UsecreaDevManagerLib.cmake
    # Look for an environment variable creaDevManagerLib_DIR.
    $ENV{creaDevManagerLib_DIR}

    # Look in places relative to the system executable search path.
    ${creaDevManagerLib_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaDevManagerLib"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaDevManagerLib
    /usr/lib/creatools/creaDevManagerLib

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaDevManagerLib will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaDevManagerLib_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaDevManagerLib_DIR)

# If creaDevManagerLib was found, load the configuration file to get the rest of the
# settings.
IF(creaDevManagerLib_DIR)
  # Make sure the creaDevManagerLibConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaDevManagerLib_DIR}/creaDevManagerLibConfig.cmake)

    # We found creaDevManagerLib.  Load the settings.
    SET(creaDevManagerLib_FOUND 1)
    INCLUDE(${creaDevManagerLib_DIR}/creaDevManagerLibConfig.cmake)

  ENDIF(EXISTS ${creaDevManagerLib_DIR}/creaDevManagerLibConfig.cmake)
ELSE(creaDevManagerLib_DIR)
  # We did not find creaDevManagerLib.
  SET(creaDevManagerLib_FOUND 0)
ENDIF(creaDevManagerLib_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaDevManagerLib_FOUND)
  # creaDevManagerLib not found, explain to the user how to specify its location.
  IF(NOT creaDevManagerLib_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaDevManagerLib_NOT_FOUND_MESSAGE})
  ELSE(NOT creaDevManagerLib_FIND_QUIETLY)
    IF(creaDevManagerLib_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaDevManagerLib_NOT_FOUND_MESSAGE})
    ENDIF(creaDevManagerLib_FIND_REQUIRED)
  ENDIF(NOT creaDevManagerLib_FIND_QUIETLY)
ENDIF(NOT creaDevManagerLib_FOUND)
