# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaEnvironment is found.  
# If creaEnvironment is not found, creaEnvironment_FOUND is set to false.
#  creaEnvironment_FOUND         - Set to true when creaEnvironment is found.
#  creaEnvironment_USE_FILE      - CMake file to use creaEnvironment.
#  creaEnvironment_MAJOR_VERSION - The creaEnvironment major version number.
#  creaEnvironment_MINOR_VERSION - The creaEnvironment minor version number 
#                       (odd non-release).
#  creaEnvironment_BUILD_VERSION - The creaEnvironment patch level 
#                       (meaningless for odd minor).
#  creaEnvironment_INCLUDE_DIRS  - Include directories for creaEnvironment
#  creaEnvironment_LIBRARY_DIRS  - Link directories for creaEnvironment libraries
#  creaEnvironment_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaEnvironment:
#  creaEnvironment_DIR  - The directory containing creaEnvironmentConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaEnvironment directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaEnvironment_DIR_DESCRIPTION "directory containing creaEnvironmentConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaEnvironment for an installation.")
SET(creaEnvironment_NOT_FOUND_MESSAGE "creaEnvironment not found.  Set the creaEnvironment_DIR cmake cache entry to the ${creaEnvironment_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaEnvironment_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaEnvironment_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaEnvironment_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaEnvironment_DIR_SEARCH2 "${creaEnvironment_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaEnvironment_DIR_SEARCH "")
  FOREACH(dir ${creaEnvironment_DIR_SEARCH2})
    SET(creaEnvironment_DIR_SEARCH ${creaEnvironment_DIR_SEARCH}
      ${dir}/../lib/lib/creatools/creaEnvironment
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaEnvironment_DIR UsecreaEnvironment.cmake
    # Look for an environment variable creaEnvironment_DIR.
    $ENV{creaEnvironment_DIR}

    # Look in places relative to the system executable search path.
    ${creaEnvironment_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaEnvironment"

    # Look in standard UNIX install locations.
    /usr/local/lib/creatools/creaEnvironment
    /usr/lib/creatools/creaEnvironment

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaEnvironment will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaEnvironment_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaEnvironment_DIR)

# If creaEnvironment was found, load the configuration file to get the rest of the
# settings.
IF(creaEnvironment_DIR)
  # Make sure the creaEnvironmentConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaEnvironment_DIR}/creaEnvironmentConfig.cmake)

    # We found creaEnvironment.  Load the settings.
    SET(creaEnvironment_FOUND 1)
    INCLUDE(${creaEnvironment_DIR}/creaEnvironmentConfig.cmake)

  ENDIF(EXISTS ${creaEnvironment_DIR}/creaEnvironmentConfig.cmake)
ELSE(creaEnvironment_DIR)
  # We did not find creaEnvironment.
  SET(creaEnvironment_FOUND 0)
ENDIF(creaEnvironment_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaEnvironment_FOUND)
  # creaEnvironment not found, explain to the user how to specify its location.
  IF(NOT creaEnvironment_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaEnvironment_NOT_FOUND_MESSAGE})
  ELSE(NOT creaEnvironment_FIND_QUIETLY)
    IF(creaEnvironment_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaEnvironment_NOT_FOUND_MESSAGE})
    ENDIF(creaEnvironment_FIND_REQUIRED)
  ENDIF(NOT creaEnvironment_FIND_QUIETLY)
ENDIF(NOT creaEnvironment_FOUND)
