#-----------------------------------------------------------------------------
#
# GDCMConfig.cmake - CMake configuration file for external projects.
#
# This file is configured by GDCM and used by the UseGDCM.cmake 
# module to load GDCM's settings for an external project.

# Compute the installation prefix from GDCM_DIR.
SET(GDCM_INSTALL_PREFIX "${GDCM_DIR}")
GET_FILENAME_COMPONENT(GDCM_INSTALL_PREFIX "${GDCM_INSTALL_PREFIX}" PATH)
GET_FILENAME_COMPONENT(GDCM_INSTALL_PREFIX "${GDCM_INSTALL_PREFIX}" PATH)

# The GDCM version number.
SET(GDCM_MAJOR_VERSION "1")
SET(GDCM_MINOR_VERSION "3")
SET(GDCM_BUILD_VERSION "2")
SET(GDCM_VERSION       "1.3.2")

# The libraries.
SET(GDCM_LIBRARIES "gdcm")

# The list of available languages.
#SET(GDCM_LANGUAGES "Python")

# The gdcm namespace
SET(GDCM_NAME_SPACE gdcm13)

# The CMake macros dir.
SET(GDCM_CMAKE_DIR "${GDCM_INSTALL_PREFIX}/lib/gdcm/CMake")

# The configuration options.
SET(GDCM_BUILD_SHARED_LIBS "")
#SET(GDCM_USE_HTML_HELP "")

# The C and C++ flags added to the cmake-configured flags.
SET(GDCM_REQUIRED_C_FLAGS 
  "")
SET(GDCM_REQUIRED_CXX_FLAGS 
  "")
SET(GDCM_REQUIRED_EXE_LINKER_FLAGS 
  "")
SET(GDCM_REQUIRED_SHARED_LINKER_FLAGS 
  "")
SET(GDCM_REQUIRED_MODULE_LINKER_FLAGS 
  "")

# The "use" file.
SET(GDCM_USE_FILE "${GDCM_INSTALL_PREFIX}/lib/gdcm/UseGDCM.cmake")

# The build settings file.
SET(GDCM_BUILD_SETTINGS_FILE "${GDCM_INSTALL_PREFIX}/lib/gdcm/GDCMBuildSettings.cmake")

# The library directories.
SET(GDCM_LIBRARY_DIRS "${GDCM_INSTALL_PREFIX}/lib/gdcm")

# The runtime directories.
# Note that if GDCM_CONFIGURATION_TYPES is set (see below) then
# these directories will be the parent directories under which there will
# be a directory of runtime binaries for each configuration type.
SET(GDCM_RUNTIME_DIRS "${GDCM_INSTALL_PREFIX}/lib/gdcm")

# The include directories.
SET(GDCM_INCLUDE_DIRS "${GDCM_INSTALL_PREFIX}/include/gdcm")

# The library dependencies file.
IF(NOT GDCM_NO_LIBRARY_DEPENDS)
  INCLUDE("${GDCM_INSTALL_PREFIX}/lib/gdcm/GDCMLibraryDepends.cmake")
ENDIF(NOT GDCM_NO_LIBRARY_DEPENDS)

# The data dir.
SET(GDCM_DATA_DIR "${GDCM_INSTALL_PREFIX}/share/gdcm/Data")

# The examples dir.
SET(GDCM_EXAMPLES_DIR "${GDCM_INSTALL_PREFIX}/share/gdcm/Examples")

# The resources dir.
SET(GDCM_RESOURCES_DIR "")
SET(GDCM_RESOURCE_MAJOR_VERSION 
  "")
SET(GDCM_RESOURCE_MINOR_VERSION 
  "")
SET(GDCM_RESOURCE_APPLICATION_NAME 
  "")
SET(GDCM_RESOURCE_FILE_NAME 
  "")
SET(GDCM_RESOURCE_COMPANY_NAME 
  "")

# The Tcl/Tk options.
#SET(GDCM_TCL_PACKAGE_INDEX_DIR 
#  "")

# The Python options.
SET(GDCM_PYTHON_MODULE_DIR
  "")

# The Doxygen options.
SET(GDCM_DOXYGEN_DIR "${GDCM_INSTALL_PREFIX}")

# The VTK options.
SET(GDCM_VTK_DIR "/Users/davila/Creatis/C23/tpli/lib/cmake/vtk-9.2")

# An install tree always provides one build configuration.
# A build tree may provide either one or multiple build
# configurations depending on the CMake generator used. Since
# this project can be used either from a build tree or an install tree it
# is useful for outside projects to know the configurations available.
# If this GDCMConfig.cmake is in an install tree
# GDCM_CONFIGURATION_TYPES will be empty and GDCM_BUILD_TYPE
# will be set to the value of CMAKE_BUILD_TYPE used to build
# GDCM. If GDCMConfig.cmake is in a build tree
# then GDCM_CONFIGURATION_TYPES and GDCM_BUILD_TYPE will
# have values matching CMAKE_CONFIGURATION_TYPES and CMAKE_BUILD_TYPE
# for that build tree (only one will ever be set).
SET(GDCM_CONFIGURATION_TYPES )
SET(GDCM_BUILD_TYPE Release)
