#!/bin/tcsh
#
# DEBUG mode: set logfile to a real filename
#set logfile=/tmp/bouml.log
set logfile=/dev/null
#
echo "Date : `date` " >>! $logfile
if ( $?BOUML_DIR ) then
    echo BOUML_DIR already defined: $BOUML_DIR >>! $logfile
else
    if ( $# < 1 ) then
        setenv BOUML_DIR /Applications/bouml
        echo setenv BOUML_DIR $BOUML_DIR >>! $logfile
    else
        setenv BOUML_DIR "$1"
        echo BOUML_DIR defined as argument: $BOUML_DIR >>! $logfile
    endif
    setenv BOUML_PATH "$BOUML_DIR"/.bin
    foreach appli ( "$BOUML_DIR"/.bin/*.app )
        setenv BOUML_PATH "${BOUML_PATH}:$appli/Contents/MacOS"
    end
    if ( $?PATH ) then
        setenv PATH "${PATH}:$BOUML_PATH"
    else
        setenv PATH "${BOUML_PATH}:/bin:/sbin:/usr/bin:/usr/sbin"
    endif
    if ( $?DYLD_LIBRARY_PATH ) then
        setenv DYLD_LIBRARY_PATH "$BOUML_DIR/.lib/qtlib:$DYLD_LIBRARY_PATH"
    else
        setenv DYLD_LIBRARY_PATH "$BOUML_DIR/.lib/qtlib:/usr/lib"
    endif
endif
setenv BOUML_LIB_DIR "$BOUML_DIR"/lang
#
# all available languages on this system: this may be too much, kept for reference only
#set apple_languages=(`defaults read NSGlobalDomain AppleLanguages | sed -e 's/(//g' -e 's/,//g' -e 's/)//g'`)
#echo Mac OS languages=${languages}   >>! $logfile
#echo nb_languages = $#languages      >>! $logfile
# hopefully, the first language is the language used by the user
#echo languages\[1\] = $languages[1]  >>! $logfile
#
# the default language used on this system
set apple_locale=(`defaults read NSGlobalDomain AppleLocale`)
#
if ( ! $?LANG) then
  setenv LANG "$apple_locale"
  echo "LANG undefined ! " >>! $logfile
  echo " => setenv LANG  $LANG"  >>! $logfile
else
  echo LANG=$LANG >>! $logfile
endif
#
echo PATH=$PATH >>! $logfile
echo BOUML_DIR=$BOUML_DIR >>! $logfile
echo BOUML_LIB_DIR=$BOUML_LIB_DIR >>! $logfile
"$BOUML_DIR/.bin/bouml.app/Contents/MacOS/bouml" &
