%% Noise computation for 3D image stacks of confocal Microscopy


%% Front Stack

clear();
addpath('./libs'); addpath('./Data')

%% Data (These data where used to compute noise in the FRONT stack)

name1 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140830_F_Channel1_800x800x300';
name2 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140901_F_Channel1_800x800x300';
name3 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140905_F_Channel1_800x800x300';
name4 = 'TH-LexA_LexAopmCD2GFP_Tdc2-GAL4_UASDsRed_UASSytHA_5days_25C_150707_F_Channel2_800x800x300_2';
name5 = 'TH-LexA_LexAopmCD2GFP_Tdc2-GAL4_UASDsRed_UASSytHA_5days_25C_150707_02_F_Channel2_800x800x300_2';

%% Data (These data where used to compute noise in the BACK stack)

name1 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140830_B_Channel1_800x800x300';
name2 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140901_B_Channel1_800x800x300';
name3 = 'TDC2-GAL4_mCD8GFP_aTH_SytHA_140905_B_Channel1_800x800x300';
name4 = 'TH-LexA_LexAopmCD2GFP_Tdc2-GAL4_UASDsRed_UASSytHA_5days_25C_150707_B_Channel2_800x800x300';
name5b = 'TH-LexA_LexAopmCD2GFP_Tdc2-GAL4_UASDsRed_UASSytHA_5days_25C_150708_2_B_Channel2_800x800x300';


%% Data Loading (3D tiff files)
Image1 = myreadtif(strcat('Data\',name1,'.tif')); Image1 = double(Image1{1});
Image2 = myreadtif(strcat('Data\',name2,'.tif')); Image2 = double(Image2{1});
Image3 = myreadtif(strcat('Data\',name3,'.tif')); Image3 = double(Image3{1});
Image4 = myreadtif(strcat('Data\',name4,'.tif')); Image4 = double(Image4{1});
Image5 = myreadtif(strcat('Data\',name5,'.tif')); Image5 = double(Image5{1});

%% Binary loading for 8bits data (tiff files)

Binary1 = myreadtif(strcat('Data\',name1,'_Binary.tif')); Binary1 = double(Binary1{1})/255;
Binary2 = myreadtif(strcat('Data\',name2,'_Binary.tif')); Binary2 = double(Binary2{1})/255;
Binary3 = myreadtif(strcat('Data\',name3,'_Binary.tif')); Binary3 = double(Binary3{1})/255;
Binary4 = myreadtif(strcat('Data\',name4,'_Binary.tif')); Binary4 = double(Binary4{1})/255;
Binary5 = myreadtif(strcat('Data\',name5,'_Binary.tif')); Binary5 = double(Binary5{1})/255;

%% Signal Noise computation

[x, y, z] = size(Image1);

Signal1 = Binary1.*Image1; Background1 = ~Binary1.*Image1;
clear Image1; clear Binary1;
Signal2 = Binary2.*Image2; Background2 = ~Binary2.*Image2;
clear Image2; clear Binary2;
Signal3 = Binary3.*Image3; Background3 = ~Binary3.*Image3;
clear Image05; clear Binary05l;
Signal4 = Binary4.*Image4; Background4 = ~Binary4.*Image4;
clear Image07; clear Binary07l;
Signal5 = Binary5.*Image5; Background5 = ~Binary5.*Image5;
clear Image07b; clear Binary07lb;

[k1s, t1s] = gammaParam3D(Signal1);
[k2s, t2s] = gammaParam3D(Signal2);
[k3s, t3s] = gammaParam3D(Signal3);
[k4s, t4s] = gammaParam3D(Signal4);
[k5s, t5s] = gammaParam3D(Signal5);

ks = cat(1, k1s, k2, k3, k4, k5); ksstd = std(ks); ks = mean(ks);
ts = cat(1, t1s, t2, t3, t4, t5); tsstd = std(ts); ts = mean(ts);

kp = ks+ksstd; km = ks-ksstd;
tp = ts+tsstd; tm = ts-tsstd;

start = 1;
range = 0:z;

figure,
subplot(2,1,1); plot(range,k1(start:z),'m--',range,k2(start:z),'y--',range,k3(start:z),'c--',range,k4(start:z),'g--',range,k5(start:z),'b--',range,ks(start:z),'r','linewidth',2); xlabel('slice','fontsize',14); ylabel('k','fontsize',14);
subplot(2,1,2); plot(range,t1(start:z),'m--',range,t2(start:z),'y--',range,t3(start:z),'c--',range,t4(start:z),'g--',range,t5(start:z),'b--',range,ts(start:z),'r','linewidth',2); xlabel('slice','fontsize',14); ylabel('t','fontsize',14);

figure,
subplot(2,1,1); plot(start:z,ks(start:z),'r',start:z,kp(start:z),'c--',start:z,km(start:z),'c--','linewidth',2); xlabel('slice'); xlabel('slice','fontsize',14); ylabel('k','fontsize',14);
subplot(2,1,2); plot(start:z,ts(start:z),'r',start:z,tp(start:z),'c--',start:z,tm(start:z),'c--','linewidth',2); xlabel('slice'); xlabel('slice','fontsize',14); ylabel('t','fontsize',14);

%% Background noise computation

[k1b, t1b] = gammaParam3D(Background1);
[k2b, t2b] = gammaParam3D(Background2);
[k3b, t3b] = gammaParam3D(Background3);
[k4b, t4b] = gammaParam3D(Background4);
[k5b, t5b] = gammaParam3D(Background5);

start = 50;

kb = cat(1, k1b, k2b, k3b, k4b, k5b); kbstd = std(kb); kb = mean(kb);
tb = cat(1, t1b, t2b, t3b, t4b, t5b); tbstd = std(tb); tb = mean(tb);

kpb = kb+kbstd; kmb = kb-kbstd;
tpb = tb+tbstd; tmb = tb-tbstd;

figure,
subplot(2,1,1); plot(range,k1b(start:z),'m--',range,k2b(start:z),'y--',range,k3b(start:z),'c--',range,k4b(start:z),'g--',range,k5b(start:z),'b--',range,kb(start:z),'r','linewidth',2); xlabel('slice','fontsize',14); ylabel('k','fontsize',14);
subplot(2,1,2); plot(range,t1b(start:z),'m--',range,t2b(start:z),'y--',range,t3b(start:z),'c--',range,t4b(start:z),'g--',range,t5b(start:z),'b--',range,tb(start:z),'r','linewidth',2); xlabel('slice','fontsize',14); ylabel('t','fontsize',14);

clear Signal1; clear Signal2; clear Signal3; clear Signal4l; clear Signal5;
clear Background1; clear Background2; clear Background3; clear Background4; clear Background5;

%% Simulated Noise filter computation (FRONT)

SignalNoise = gammaNoise3D(ks,ts,x,y,z-start);
BackgroundNoise = gammaNoise3D(kb,tb,x,y,z-start);



%% Display some slice of the computed filters

figure,
subplot(2,2,1); imshow(SignalNoise(:,:,50),[0 255]);
subplot(2,2,2); imshow(SignalNoise(:,:,250),[0 255]);
subplot(2,2,3); imshow(BackgroundNoise(:,:,50),[0 255]);
subplot(2,2,4); imshow(BackgroundNoise(:,:,250),[0 255]);

%% Tubular structures data (These data were used for the FRONT stack)

name1 = 'Test-Fibers_binary_blur'; % Blurred version of the mask for more realistic data
name2 = 'Test-Fibers_binary'; % Same stack of binary tubular structure

Image1 = myreadtif(strcat('Data\',name1,'.tif')); Image1 = double(Image1{1});
Image2 = myreadtif(strcat('Data\',name2,'.tif')); Image2 = double(Image2{1})/255;

MyImage = Image1(:,:,1:250); % Substack selection
MyMask = Image2(:,:,1:250); % Substack selection

%% Tubular structures data (These data were used for the BACK stack)

SignalNoise = fliplr(SignalNoise);
BackgroundNoise = fliplr(BackgroundNoise);

% This stack is the SAME as the front one BUT ROTATED
name = 'Test-Fibers_binary_115_blur'; 
name2 = 'Test-Fibers_binary_115';

Image1 = myreadtif(strcat('Data\',name1,'.tif')); Image1 = double(Image1{1});
Image2 = myreadtif(strcat('Data\',name2,'.tif')); Image2 = double(Image2{1})/255;

MyImage = Image(:,:,51:300);
MyMask = Image2(:,:,51:300);

%% Apply this Noise to binary mask of tubular structures

 Final = (~MyMask).*BackgroundNoise + MyMask.*SignalNoise + MyImage;

%% Display Some slices of the artificial data

figure,
subplot(2,2,1); imshow(MyImage(:,:,100),[0 255]);
subplot(2,2,2); imshow(MyMask(:,:,100),[0 1]);
subplot(2,2,3); imshow(BackgroundNoise(:,:,100),[0 255]);
subplot(2,2,4); imshow(Front(:,:,100),[0 255]);

figure,
subplot(2,2,1); imshow(Front(:,:,50),[0 255]);
subplot(2,2,2); imshow(Front(:,:,100),[0 255]);
subplot(2,2,3); imshow(Front(:,:,200),[0 255]);
subplot(2,2,4); imshow(Front(:,:,250),[0 255]);

%% Save the data

for i = 1:z
    imwrite(uint16(Final(:,:,i)),strcat(int2str(i),'.tif'));
end