function [img,RGB]=myreadtif(fname)

h = waitbar(0,'loading image');

info = imfinfo(fname);
num_images = numel(info);
RGB=false;

channels=-1;
numslices=-1;
%has imageJ image tags
if isfield(info,'ImageDescription')
    tmp=textscan(info(1).ImageDescription,'%s');
    tmp=tmp{1};
    for c=1:numel(tmp)
        if strfind(tmp{c},'channels')
            channels=str2num(tmp{c}(strfind(tmp{c},'=')+1:end));
        else
            if strfind(tmp{c},'images')
                channels=1;
            end;
        end;
        if strfind(tmp{c},'slices')
            numslices=str2num(tmp{c}(strfind(tmp{c},'=')+1:end));
        end;    
    end;
    if channels>1 && numslices>-1
        RGB=true;
        num_images=num_images/channels;
    end;
end;

k2=0;
k3=0;
for k = 1:num_images
    if channels>-1 || k==1
        A = single(imread(fname, k));
         if numel(size(A))==3
             RGB=true;
             channels=-1;
         end;
    end;
    if k==1,
        if RGB || strcmp(info(1).PhotometricInterpretation,'RGB')
            RGB=true;
            shape=size(A);
            if channels==-1
                img{1}=zeros([shape([1:2]),num_images],'single');
                img{2}=zeros([shape([1:2]),num_images],'single');
                img{3}=zeros([shape([1:2]),num_images],'single');
            else
                for c=1:channels
                    img{c}=zeros([shape([1:2]),num_images],'single');
                end;
            end;
        else
            img{1}=zeros([size(A),num_images],'single');
        end;
        
    end;
    if (RGB)
        waitbar(k / num_images,h,'loading RGB image')
        if channels==-1
            A = single(imread(fname, k));
            img{1}(:,:,k)=squeeze(A(:,:,1));
            img{2}(:,:,k)=squeeze(A(:,:,2));
            img{3}(:,:,k)=squeeze(A(:,:,3));
        else
            k2=k2+1;
            for c=1:channels
                k3=k3+1;
                A = single(imread(fname, k3));
                img{c}(:,:,k2)=squeeze(A);
            end;
        end;
    else
        waitbar(k / num_images,h);
        A = single(imread(fname, k));
        img{1}(:,:,k)=A;
    end;
    

end
close(h) 

% adding white channel for Ito sensei
if numel(img)==3
    if sum(img{3}(:))==0
        img{3}=img{1}.*img{2};
    end;
end;
if channels==2
    img{3}=img{1}.*img{2};
end;
    

